/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.common.item.module.energy_generation;

import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.common.capabilities.module.powermodule.IConfig;
import lehjr.numina.common.capabilities.module.powermodule.IPowerModule;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.capabilities.module.powermodule.ModuleTarget;
import lehjr.numina.common.capabilities.module.powermodule.PowerModuleCapability;
import lehjr.numina.common.capabilities.module.tickable.PlayerTickModule;
import lehjr.numina.common.energy.ElectricItemUtils;
import lehjr.numina.common.heat.HeatUtils;
import lehjr.powersuits.common.config.MPSSettings;
import lehjr.powersuits.common.item.module.AbstractPowerModule;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class AdvancedSolarGeneratorModule
extends AbstractPowerModule {
    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapProvider(stack);
    }

    public class CapProvider
    implements ICapabilityProvider {
        ItemStack module;
        private final Ticker ticker;
        private final LazyOptional<IPowerModule> powerModuleHolder;

        public CapProvider(ItemStack module) {
            this.module = module;
            this.ticker = new Ticker(module, ModuleCategory.ENERGY_GENERATION, ModuleTarget.HEADONLY, MPSSettings::getModuleConfig){
                {
                    super(module, category, target, config);
                    this.addBaseProperty("daytimeEnergyGen", 45000.0, "FE");
                    this.addBaseProperty("nightTimeEnergyGen", 1500.0, "FE");
                    this.addBaseProperty("daytimeHeatGen", 15.0);
                    this.addBaseProperty("nightTimeHeatGen", 5.0);
                }
            };
            this.powerModuleHolder = LazyOptional.of(() -> {
                this.ticker.updateFromNBT();
                return this.ticker;
            });
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            LazyOptional powerModuleCapability = PowerModuleCapability.POWER_MODULE.orEmpty(capability, this.powerModuleHolder);
            if (powerModuleCapability.isPresent()) {
                return powerModuleCapability;
            }
            return LazyOptional.empty();
        }

        class Ticker
        extends PlayerTickModule {
            public Ticker(ItemStack module, ModuleCategory category, ModuleTarget target, Callable<IConfig> config) {
                super(module, category, target, config, true);
            }

            public int getTier() {
                return 2;
            }

            public String getModuleGroup() {
                return "Energy Generation";
            }

            public void onPlayerTickActive(PlayerEntity player, ItemStack itemStack) {
                boolean moonVisible;
                World world = player.field_70170_p;
                boolean canRain = true;
                if (world.func_82737_E() % 20L == 0L) {
                    canRain = world.func_226691_t_(player.func_233580_cy_()).func_201851_b() != Biome.RainType.NONE;
                }
                boolean isRaining = canRain && (world.func_72896_J() || world.func_72911_I());
                boolean sunVisible = world.func_72935_r() && !isRaining && world.func_175710_j(player.func_233580_cy_().func_177984_a());
                boolean bl = moonVisible = !world.func_72935_r() && !isRaining && world.func_175710_j(player.func_233580_cy_().func_177984_a());
                if (!world.field_72995_K && world.func_230315_m_().func_218272_d() && world.func_82737_E() % 80L == 0L) {
                    float lightLevelScaled = (float)(world.func_226658_a_(LightType.SKY, player.func_233580_cy_().func_177984_a()) - world.func_175657_ab()) / 15.0f;
                    if (sunVisible) {
                        ElectricItemUtils.givePlayerEnergy((LivingEntity)player, (int)((int)(this.applyPropertyModifiers("daytimeEnergyGen") * (double)lightLevelScaled)));
                        HeatUtils.heatPlayer((LivingEntity)player, (double)(this.applyPropertyModifiers("daytimeHeatGen") * (double)lightLevelScaled / 2.0));
                    } else if (moonVisible) {
                        ElectricItemUtils.givePlayerEnergy((LivingEntity)player, (int)((int)(this.applyPropertyModifiers("nightTimeEnergyGen") * (double)lightLevelScaled)));
                        HeatUtils.heatPlayer((LivingEntity)player, (double)(this.applyPropertyModifiers("nightTimeHeatGen") * (double)lightLevelScaled / 2.0));
                    }
                }
            }
        }
    }
}

