/*
 * Decompiled with CFR 0.152.
 */
package lehjr.powersuits.common.capability;

import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lehjr.numina.common.capabilities.heat.HeatCapability;
import lehjr.numina.common.capabilities.heat.HeatItemWrapper;
import lehjr.numina.common.capabilities.heat.IHeatStorage;
import lehjr.numina.common.capabilities.inventory.modechanging.ModeChangingModularItem;
import lehjr.numina.common.capabilities.inventory.modularitem.NuminaRangedWrapper;
import lehjr.numina.common.capabilities.module.powermodule.ModuleCategory;
import lehjr.numina.common.capabilities.render.IModelSpecNBT;
import lehjr.numina.common.capabilities.render.ModelSpecNBT;
import lehjr.numina.common.capabilities.render.ModelSpecNBTCapability;
import lehjr.powersuits.client.render.PowerFistSpecNBT;
import lehjr.powersuits.common.config.MPSSettings;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class PowerFistCap
implements ICapabilityProvider {
    final ItemStack itemStack;
    final EquipmentSlotType targetSlot;
    final ModeChangingModularItem modularItem;
    final LazyOptional<IItemHandler> modularItemHolder;
    final ModelSpecNBT modelSpec;
    final LazyOptional<IModelSpecNBT> modelSpecHolder;
    final HeatItemWrapper heatStorage;
    final LazyOptional<IHeatStorage> heatHolder;

    public PowerFistCap(@Nonnull ItemStack itemStackIn) {
        this.itemStack = itemStackIn;
        this.targetSlot = EquipmentSlotType.MAINHAND;
        this.modularItem = new ModeChangingModularItem(this.itemStack, 40){
            {
                HashMap<ModuleCategory, NuminaRangedWrapper> rangedWrapperMap = new HashMap<ModuleCategory, NuminaRangedWrapper>();
                rangedWrapperMap.put(ModuleCategory.ENERGY_STORAGE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 0, 1));
                rangedWrapperMap.put(ModuleCategory.NONE, new NuminaRangedWrapper((IItemHandlerModifiable)this, 1, this.getSlots()));
                this.setRangedWrapperMap(rangedWrapperMap);
            }
        };
        this.modularItemHolder = LazyOptional.of(() -> {
            this.modularItem.updateFromNBT();
            return this.modularItem;
        });
        this.modelSpec = new PowerFistSpecNBT(this.itemStack);
        this.modelSpecHolder = LazyOptional.of(() -> this.modelSpec);
        this.heatStorage = new HeatItemWrapper(this.itemStack, MPSSettings.getMaxHeatPowerFist());
        this.heatHolder = LazyOptional.of(() -> {
            this.modularItem.updateFromNBT();
            this.heatStorage.updateFromNBT();
            return this.heatStorage;
        });
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == null) {
            return LazyOptional.empty();
        }
        LazyOptional modularItemCapability = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.modularItemHolder);
        if (modularItemCapability.isPresent()) {
            return modularItemCapability;
        }
        LazyOptional modelSpecCapability = ModelSpecNBTCapability.RENDER.orEmpty(cap, this.modelSpecHolder);
        if (modelSpecCapability.isPresent()) {
            return modelSpecCapability;
        }
        LazyOptional heatCapability = HeatCapability.HEAT.orEmpty(cap, this.heatHolder);
        if (heatCapability.isPresent()) {
            return heatCapability;
        }
        if (cap == CapabilityEnergy.ENERGY) {
            this.modularItem.updateFromNBT();
            return this.modularItem.getStackInSlot(0).getCapability(cap, side);
        }
        return LazyOptional.empty();
    }
}

