/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.util;

import dev.ftb.mods.ftbic.block.entity.machine.TeleporterBlockEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class TeleporterEntry
implements Comparable<TeleporterEntry> {
    public final RegistryKey<World> dimension;
    public final BlockPos pos;
    public final String name;
    public final String placerName;
    public final double energyUse;

    public TeleporterEntry(TeleporterBlockEntity e, double u) {
        this.dimension = e.func_145831_w().func_234923_W_();
        this.pos = e.func_174877_v();
        this.name = e.name;
        this.placerName = e.isPublic ? e.placerName : "";
        this.energyUse = u;
    }

    public TeleporterEntry(PacketBuffer buf) {
        this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)buf.func_192575_l());
        this.pos = buf.func_179259_c();
        this.name = buf.func_150789_c(Short.MAX_VALUE);
        this.placerName = buf.func_150789_c(Short.MAX_VALUE);
        this.energyUse = buf.readDouble();
    }

    public void write(PacketBuffer buf) {
        buf.func_192572_a(this.dimension.func_240901_a_());
        buf.func_179255_a(this.pos);
        buf.func_211400_a(this.name, Short.MAX_VALUE);
        buf.func_211400_a(this.placerName, Short.MAX_VALUE);
        buf.writeDouble(this.energyUse);
    }

    @Override
    public int compareTo(@NotNull TeleporterEntry o) {
        int i = Boolean.compare(this.placerName.isEmpty(), o.placerName.isEmpty());
        if (i == 0) {
            i = Double.compare(this.energyUse, o.energyUse);
        }
        if (i == 0) {
            i = this.name.compareToIgnoreCase(o.name);
        }
        return i;
    }
}

