/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.util;

import com.mojang.authlib.GameProfile;
import dev.ftb.mods.ftbic.FTBIC;
import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.FTBICBlocks;
import dev.ftb.mods.ftbic.util.FTBChunksIntegration;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.FakePlayer;

public class NuclearExplosion
extends Thread
implements Comparator<NukeTask> {
    public static final int FLAG_IN_EXPLOSION = 1;
    public static final int FLAG_IS_REINFORCED = 2;
    public static final int FLAG_DESTROY = 4;
    public static final int FLAG_IS_AIR = 8;
    public static final int FLAG_IS_BLOCK = 16;
    public static final int FLAG_INSIDE = 32;
    public static final int FLAG_OUTSIDE = 64;
    public static final Runnable NO_ACTION = () -> {};
    public final MinecraftServer server;
    public final ServerWorld level;
    public final BlockPos pos;
    public final double radius;
    public final List<NukeTask> tasks;
    public final UUID owner;
    public final String ownerName;
    public final long delay;
    public final Runnable preExplosion;

    public static boolean hasFlag(int flags, int flag) {
        return (flags & flag) != 0;
    }

    public static boolean hasFlag(int flags, int flag1, int flag2) {
        return NuclearExplosion.hasFlag(flags, flag1) && NuclearExplosion.hasFlag(flags, flag2);
    }

    public static boolean hasFlag(int flags, int flag1, int flag2, int flag3) {
        return NuclearExplosion.hasFlag(flags, flag1) && NuclearExplosion.hasFlag(flags, flag2) && NuclearExplosion.hasFlag(flags, flag3);
    }

    public static int removeFlag(int flags, int flag) {
        return flags & ~flag;
    }

    public static Builder builder(ServerWorld level, BlockPos pos, double radius, UUID owner, String ownerName) {
        return new Builder(level, pos, radius, owner, ownerName);
    }

    private NuclearExplosion(ServerWorld level, BlockPos pos, double radius, UUID owner, String ownerName, long delay, Runnable preExplosion) {
        super("NuclearExplosion/dn=" + level.func_234923_W_().func_240901_a_().func_110624_b() + "/dp=" + level.func_234923_W_().func_240901_a_().func_110623_a() + "/p=" + pos.func_177958_n() + "," + pos.func_177956_o() + "," + pos.func_177952_p() + "/r=" + radius + "/o=" + owner + "/on=" + ownerName);
        this.server = level.func_73046_m();
        this.level = level;
        this.pos = pos;
        this.radius = Math.min(radius, 100.0);
        this.tasks = new ArrayList<NukeTask>();
        this.owner = owner;
        this.ownerName = ownerName;
        this.delay = delay;
        this.preExplosion = preExplosion;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        void var33_47;
        int oldLight;
        int flags;
        long startTime = System.currentTimeMillis();
        int rxz = MathHelper.func_76143_f((double)this.radius);
        double ry = Math.min(this.radius * 0.75, 60.0);
        double rys = ry / this.radius;
        int ry0 = Math.max(this.pos.func_177956_o() - MathHelper.func_76143_f((double)(ry * 2.0)), 0);
        int ry1 = Math.min(this.pos.func_177956_o() + MathHelper.func_76143_f((double)(ry * 2.0)), this.level.func_234938_ad_()) - 1;
        double rsq = this.radius * this.radius;
        double rsqc = this.radius * 0.65 * (this.radius * 0.65);
        long seed = System.currentTimeMillis() + (long)this.pos.hashCode();
        Random random0 = new Random(seed);
        Random random = new Random(seed);
        int volume = 0;
        for (int x = -rxz; x <= rxz; ++x) {
            for (int z = -rxz; z <= rxz; ++z) {
                for (int y = ry1; y >= ry0; --y) {
                    int y0 = y - this.pos.func_177956_o();
                    double y1 = (double)y0 / rys;
                    double dist = ((double)(x * x) + y1 * y1 + (double)(z * z)) / (1.0 - random0.nextDouble() * 0.25);
                    if (!(dist <= rsq)) continue;
                    ++volume;
                }
            }
        }
        FTBIC.LOGGER.warn(String.format("%s/%s created a nuclear explosion with radius %f at %s:%d,%d,%d with up to %d blocks to check", this.ownerName, this.owner, this.radius, this.level.func_234923_W_().func_240901_a_(), this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p(), volume));
        BlockPos.Mutable mpos = new BlockPos.Mutable();
        Object2IntOpenHashMap blocks = new Object2IntOpenHashMap(volume);
        blocks.defaultReturnValue(0);
        ArrayList<BlockPos> crust = new ArrayList<BlockPos>();
        FakePlayer player = new FakePlayer(this.level, new GameProfile(this.owner, this.ownerName));
        player.func_70107_b((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5);
        for (int x = -rxz; x <= rxz; ++x) {
            for (int z = -rxz; z <= rxz; ++z) {
                boolean blockProtected;
                mpos.func_181079_c(this.pos.func_177958_n() + x, 0, this.pos.func_177952_p() + z);
                boolean bl = blockProtected = FTBChunksIntegration.instance.isProtected(this.level, (BlockPos)mpos, this.owner) || !this.level.func_175660_a((PlayerEntity)player, (BlockPos)mpos);
                if (!World.func_175701_a((BlockPos)mpos)) continue;
                for (int y = ry1; y >= ry0; --y) {
                    int y0 = y - this.pos.func_177956_o();
                    double y1 = (double)y0 / rys;
                    double dist = ((double)(x * x) + y1 * y1 + (double)(z * z)) / (1.0 - random.nextDouble() * 0.25);
                    if (!(dist <= rsq)) continue;
                    mpos.func_185336_p(y);
                    if (World.func_189509_E((BlockPos)mpos)) continue;
                    BlockPos ipos = mpos.func_185334_h();
                    try {
                        BlockState blockState = this.level.func_180495_p((BlockPos)mpos);
                        if (blockProtected) {
                            blocks.put((Object)ipos, 35);
                        } else if (blockState.func_196958_f()) {
                            blocks.put((Object)ipos, 41);
                        } else if (FTBICUtils.REINFORCED.func_230235_a_((Object)blockState.func_177230_c()) || blockState.func_185887_b((IBlockReader)this.level, (BlockPos)mpos) < 0.0f) {
                            blocks.put((Object)ipos, 35);
                        } else {
                            blocks.put((Object)ipos, 49);
                        }
                    }
                    catch (Exception exception) {
                        FTBIC.LOGGER.warn("Error while calculating nuclear explosion", (Throwable)exception);
                        blocks.put((Object)ipos, 35);
                    }
                    if (!(dist >= rsqc)) continue;
                    crust.add(ipos);
                }
            }
        }
        crust.removeIf(new CrustFilter(blocks, mpos));
        ArrayList<NukeTask> tasks = new ArrayList<NukeTask>();
        BlockState air = Blocks.field_150350_a.func_176223_P();
        BlockState podzol = Blocks.field_196661_l.func_176223_P();
        BlockState coarseDirt = Blocks.field_196660_k.func_176223_P();
        BlockState fire = Blocks.field_150480_ab.func_176223_P();
        BlockState cobble = Blocks.field_150347_e.func_176223_P();
        BlockState exfluid = FTBICBlocks.EXFLUID.get().func_176223_P();
        if (!NuclearExplosion.hasFlag(blocks.getOrDefault((Object)this.pos, 0), 2)) {
            tasks.add(new BlockModification(this.pos, air, 3, rxz));
        }
        double step = 0.5;
        block18: for (BlockPos blockPos : crust) {
            int flags2 = blocks.getOrDefault((Object)blockPos, 0);
            if (NuclearExplosion.hasFlag(flags2, 1)) {
                blocks.put((Object)blockPos, NuclearExplosion.removeFlag(flags2 | 0x40, 32));
            }
            int x0 = this.pos.func_177958_n() - blockPos.func_177958_n();
            int y0 = this.pos.func_177956_o() - blockPos.func_177956_o();
            int z0 = this.pos.func_177952_p() - blockPos.func_177952_p();
            int distSq = x0 * x0 + y0 * y0 + z0 * z0;
            double dist = Math.sqrt(distSq);
            int px = 0;
            int py = 0;
            int pz = 0;
            for (double l = 0.0; l <= dist; l += step) {
                int x = MathHelper.func_76128_c((double)((double)x0 * l / dist + 0.5));
                int y = MathHelper.func_76128_c((double)((double)y0 * l / dist + 0.5));
                int z = MathHelper.func_76128_c((double)((double)z0 * l / dist + 0.5));
                if (px == x && py == y && pz == z) continue;
                px = x;
                py = y;
                pz = z;
                mpos.func_181079_c(this.pos.func_177958_n() + x, this.pos.func_177956_o() + y, this.pos.func_177952_p() + z);
                int flags1 = blocks.getOrDefault((Object)mpos, 0);
                if (NuclearExplosion.hasFlag(flags1, 2)) continue block18;
                if (!NuclearExplosion.hasFlag(flags1, 1) || NuclearExplosion.hasFlag(flags1, 4)) continue;
                BlockPos p1 = mpos.func_185334_h();
                blocks.put((Object)p1, flags1 | 4);
            }
        }
        ArrayList<Object2IntMap.Entry> destroyEntries = new ArrayList<Object2IntMap.Entry>();
        block20: for (Object2IntMap.Entry entry : blocks.object2IntEntrySet()) {
            flags = entry.getIntValue();
            if (NuclearExplosion.hasFlag(flags, 2) || NuclearExplosion.hasFlag(flags, 4)) continue;
            BlockPos p = (BlockPos)entry.getKey();
            int x0 = this.pos.func_177958_n() - p.func_177958_n();
            int y0 = this.pos.func_177956_o() - p.func_177956_o();
            int z0 = this.pos.func_177952_p() - p.func_177952_p();
            int distSq = x0 * x0 + y0 * y0 + z0 * z0;
            double dist = Math.sqrt(distSq);
            int px = 0;
            int py = 0;
            int pz = 0;
            for (double l = 0.0; l <= dist; l += step) {
                int x = MathHelper.func_76128_c((double)((double)x0 * l / dist + 0.5));
                int y = MathHelper.func_76128_c((double)((double)y0 * l / dist + 0.5));
                int z = MathHelper.func_76128_c((double)((double)z0 * l / dist + 0.5));
                if (px == x && py == y && pz == z) continue;
                px = x;
                py = y;
                pz = z;
                mpos.func_181079_c(this.pos.func_177958_n() + x, this.pos.func_177956_o() + y, this.pos.func_177952_p() + z);
                int flags1 = blocks.getOrDefault((Object)mpos, 0);
                if (NuclearExplosion.hasFlag(flags1, 2)) continue block20;
                if (!NuclearExplosion.hasFlag(flags1, 1) || NuclearExplosion.hasFlag(flags1, 4)) continue;
                destroyEntries.add(entry);
            }
        }
        for (Object2IntMap.Entry entry : destroyEntries) {
            entry.setValue(entry.getIntValue() | 4);
        }
        for (Object2IntMap.Entry entry : blocks.object2IntEntrySet()) {
            flags = entry.getIntValue();
            if (!NuclearExplosion.hasFlag(flags, 4, 32, 16)) continue;
            try {
                BlockPos p = (BlockPos)entry.getKey();
                BlockState state = this.level.func_180495_p(p);
                oldLight = state.getLightValue((IBlockReader)this.level, this.pos);
                int oldOpacity = state.func_200016_a((IBlockReader)this.level, this.pos);
                tasks.add(new BlockModification(p, air, 2, 0));
                tasks.add(new LightUpdate(p, state, air, oldLight, oldOpacity));
            }
            catch (Exception ex) {
                FTBIC.LOGGER.warn("Error while calculating nuclear explosion", (Throwable)ex);
            }
        }
        for (Object2IntMap.Entry entry : blocks.object2IntEntrySet()) {
            int oldOpacity;
            BlockState state;
            BlockPos p;
            flags = entry.getIntValue();
            if (NuclearExplosion.hasFlag(flags, 4, 16, 64)) {
                try {
                    p = (BlockPos)entry.getKey();
                    state = this.level.func_180495_p(p);
                    oldLight = state.getLightValue((IBlockReader)this.level, this.pos);
                    oldOpacity = state.func_200016_a((IBlockReader)this.level, this.pos);
                    if (state.func_177230_c() instanceof GrassBlock) {
                        tasks.add(new BlockModification(p, podzol));
                        tasks.add(new LightUpdate(p, state, podzol, oldLight, oldOpacity));
                        continue;
                    }
                    if (Tags.Blocks.DIRT.func_230235_a_((Object)state.func_177230_c())) {
                        tasks.add(new BlockModification(p, coarseDirt));
                        tasks.add(new LightUpdate(p, state, coarseDirt, oldLight, oldOpacity));
                        continue;
                    }
                    if (state.func_185904_a() == Material.field_151576_e || Tags.Blocks.GRAVEL.func_230235_a_((Object)state.func_177230_c()) || Tags.Blocks.SAND.func_230235_a_((Object)state.func_177230_c())) {
                        if (random.nextInt(10) == 0) {
                            BlockPos above;
                            int aboveFlags;
                            BlockState burnt = this.getBurntBlock(random);
                            tasks.add(new BlockModification(p, burnt));
                            tasks.add(new LightUpdate(p, state, burnt, oldLight, oldOpacity));
                            if (random.nextInt(8) != 0 || !NuclearExplosion.hasFlag(aboveFlags = blocks.getOrDefault((Object)(above = p.func_177984_a()), 0), 32) || NuclearExplosion.hasFlag(aboveFlags, 2)) continue;
                            tasks.add(new BlockModification(above, fire, 3, 64));
                            continue;
                        }
                        tasks.add(new BlockModification(p, cobble));
                        tasks.add(new LightUpdate(p, state, cobble, oldLight, oldOpacity));
                        continue;
                    }
                    if (state.func_185904_a().func_76224_d() || this.level.func_204610_c(p).func_206886_c() != Fluids.field_204541_a) {
                        tasks.add(new BlockModification(p, exfluid));
                        tasks.add(new LightUpdate(p, state, exfluid, oldLight, oldOpacity));
                        continue;
                    }
                    tasks.add(new LightUpdate(p, state, state, oldLight, oldOpacity));
                }
                catch (Exception ex) {
                    FTBIC.LOGGER.warn("Error while calculating nuclear explosion", (Throwable)ex);
                }
                continue;
            }
            if (!NuclearExplosion.hasFlag(flags, 4, 8, 64)) continue;
            try {
                p = (BlockPos)entry.getKey();
                state = this.level.func_180495_p(p);
                oldLight = state.getLightValue((IBlockReader)this.level, this.pos);
                oldOpacity = state.func_200016_a((IBlockReader)this.level, this.pos);
                if (random.nextInt(60) == 0) {
                    tasks.add(new BlockModification(p, exfluid));
                    tasks.add(new LightUpdate(p, state, exfluid, oldLight, oldOpacity));
                    continue;
                }
                tasks.add(new LightUpdate(p, state, state, oldLight, oldOpacity));
            }
            catch (Exception ex) {
                FTBIC.LOGGER.warn("Error while calculating nuclear explosion", (Throwable)ex);
            }
        }
        boolean bl = false;
        for (NukeTask task : tasks) {
            if (!(task instanceof BlockModification)) continue;
            ++var33_47;
        }
        long endTime = System.currentTimeMillis();
        FTBIC.LOGGER.warn(String.format("It modified %d/%d blocks and it took %d ms to calculate", (int)var33_47, blocks.size(), endTime - startTime));
        long delay1 = this.delay - (System.currentTimeMillis() - startTime);
        if (delay1 > 0L) {
            try {
                Thread.sleep(delay1);
            }
            catch (Exception ex) {
                FTBIC.LOGGER.warn("Error while calculating nuclear explosion", (Throwable)ex);
            }
        }
        this.server.func_213165_a(this.preExplosion);
        while (!tasks.isEmpty()) {
            int i;
            tasks.sort(this);
            int highestOrder = ((NukeTask)tasks.get(0)).getOrder();
            ArrayList<NukeTask> lowPriority = new ArrayList<NukeTask>();
            ArrayList<List> lists = new ArrayList<List>();
            double group = 1.5;
            for (i = MathHelper.func_76143_f((double)(this.radius / group)); i >= 0; --i) {
                lists.add(new ArrayList());
            }
            for (NukeTask task : tasks) {
                if (task.getOrder() > highestOrder) {
                    lowPriority.add(task);
                    continue;
                }
                ((List)lists.get(MathHelper.func_76125_a((int)MathHelper.func_76128_c((double)task.group(this, group)), (int)0, (int)(lists.size() - 1)))).add(task);
            }
            tasks.clear();
            tasks.addAll(lowPriority);
            lists.removeIf(List::isEmpty);
            int listsSize = lists.size();
            for (i = 0; i < listsSize; ++i) {
                List list = (List)lists.get(i);
                if (!this.server.func_71278_l()) {
                    return;
                }
                this.server.func_213165_a(() -> this.execute(list));
                if (i == listsSize - 1) continue;
                try {
                    Thread.sleep(Math.min(Math.max((long)((List)lists.get(i + 1)).size() / 20L, 50L), 150L));
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void execute(List<NukeTask> list) {
        boolean blockDrops = this.level.func_82736_K().func_223586_b(GameRules.field_223603_f);
        ((GameRules.BooleanValue)this.level.func_82736_K().func_223585_a(GameRules.field_223603_f)).func_223570_a(false, this.server);
        for (NukeTask task : list) {
            task.execute(this);
        }
        ((GameRules.BooleanValue)this.level.func_82736_K().func_223585_a(GameRules.field_223603_f)).func_223570_a(blockDrops, this.server);
    }

    private BlockState getBurntBlock(Random random) {
        switch (random.nextInt(3)) {
            case 0: {
                return Blocks.field_196814_hQ.func_176223_P();
            }
            case 1: {
                return Blocks.field_235337_cO_.func_176223_P();
            }
        }
        return Blocks.field_235406_np_.func_176223_P();
    }

    @Override
    public int compare(NukeTask o1, NukeTask o2) {
        int i = o1.getOrder() - o2.getOrder();
        return i == 0 ? o1.compare(this, o2) : i;
    }

    public static final class Builder {
        private final ServerWorld level;
        private final BlockPos pos;
        private final double radius;
        private final UUID owner;
        private final String ownerName;
        private long delay;
        private Runnable preExplosion;

        private Builder(ServerWorld level, BlockPos pos, double radius, UUID owner, String ownerName) {
            this.level = level;
            this.pos = pos;
            this.radius = Math.min(radius, 100.0);
            this.owner = owner;
            this.ownerName = ownerName;
            this.delay = 0L;
            this.preExplosion = NO_ACTION;
        }

        public Builder delay(long delay) {
            this.delay = delay;
            return this;
        }

        public Builder preExplosion(Runnable preExplosion) {
            this.preExplosion = preExplosion;
            return this;
        }

        public void create() {
            NuclearExplosion explosion = new NuclearExplosion(this.level, this.pos, this.radius, this.owner, this.ownerName, this.delay, this.preExplosion);
            if (FTBICConfig.NUCLEAR_EXPLOSION_DAEMON_THREAD) {
                explosion.setDaemon(true);
            }
            explosion.start();
        }
    }

    private static class CrustFilter
    implements Predicate<BlockPos> {
        private final Object2IntOpenHashMap<BlockPos> blocks;
        private final BlockPos.Mutable mpos;

        private CrustFilter(Object2IntOpenHashMap<BlockPos> blocks, BlockPos.Mutable mpos) {
            this.blocks = blocks;
            this.mpos = mpos;
        }

        @Override
        public boolean test(BlockPos pos) {
            for (Direction dir : FTBICUtils.DIRECTIONS) {
                this.mpos.func_181079_c(pos.func_177958_n() + dir.func_82601_c(), pos.func_177956_o() + dir.func_96559_d(), pos.func_177952_p() + dir.func_82599_e());
                if (this.blocks.containsKey((Object)this.mpos)) continue;
                return false;
            }
            return true;
        }
    }

    public static class BlockModification
    extends NukeTask {
        public final BlockState state;
        public final int flags;
        public final int neighborUpdates;

        public BlockModification(BlockPos pos, BlockState state, int flags, int neighborUpdates) {
            super(pos);
            this.state = state;
            this.flags = flags;
            this.neighborUpdates = neighborUpdates;
        }

        public BlockModification(BlockPos pos, BlockState state) {
            this(pos, state, 2, 64);
        }

        @Override
        public int getOrder() {
            return this.state.func_177230_c() instanceof FireBlock ? 2 : (this.flags != 2 || this.neighborUpdates != 0 ? 0 : 1);
        }

        @Override
        public void execute(NuclearExplosion explosion) {
            explosion.level.func_241211_a_(this.pos, this.state, (this.flags & 1) != 0 ? this.flags : this.flags | 0x80, this.neighborUpdates);
        }
    }

    public static class LightUpdate
    extends NukeTask {
        private final BlockState old;
        private final BlockState state;
        private final int oldLight;
        private final int oldOpacity;

        public LightUpdate(BlockPos pos, BlockState old, BlockState state, int oldLight, int oldOpacity) {
            super(pos);
            this.old = old;
            this.state = state;
            this.oldLight = oldLight;
            this.oldOpacity = oldOpacity;
        }

        @Override
        public int getOrder() {
            return 10;
        }

        @Override
        public int compare(NuclearExplosion explosion, NukeTask o) {
            int i = this.horizontalDistance(explosion) - o.horizontalDistance(explosion);
            int y1 = this.pos.func_177956_o() - explosion.pos.func_177956_o();
            int y2 = o.pos.func_177956_o() - explosion.pos.func_177956_o();
            return i == 0 ? y1 - y2 : i;
        }

        @Override
        public double group(NuclearExplosion explosion, double group) {
            return Math.sqrt(this.horizontalDistance(explosion)) / group;
        }

        @Override
        public void execute(NuclearExplosion explosion) {
            if (this.state.func_215691_g() || this.old.func_215691_g() || this.state.func_200016_a((IBlockReader)explosion.level, this.pos) != this.oldOpacity || this.state.getLightValue((IBlockReader)explosion.level, this.pos) != this.oldLight) {
                explosion.level.func_217381_Z().func_76320_a("queueCheckLight");
                explosion.level.func_225524_e_().func_215568_a(this.pos);
                explosion.level.func_217381_Z().func_76319_b();
            }
        }
    }

    public static class NukeTask {
        public final BlockPos pos;

        public NukeTask(BlockPos pos) {
            this.pos = pos;
        }

        public int distance(NuclearExplosion explosion) {
            int x = explosion.pos.func_177958_n() - this.pos.func_177958_n();
            int y = explosion.pos.func_177956_o() - this.pos.func_177956_o();
            int z = explosion.pos.func_177952_p() - this.pos.func_177952_p();
            return x * x + y * y + z * z;
        }

        public int horizontalDistance(NuclearExplosion explosion) {
            int x = explosion.pos.func_177958_n() - this.pos.func_177958_n();
            int z = explosion.pos.func_177952_p() - this.pos.func_177952_p();
            return x * x + z * z;
        }

        public int getOrder() {
            return 0;
        }

        public int compare(NuclearExplosion explosion, NukeTask o) {
            return this.distance(explosion) - o.distance(explosion);
        }

        public double group(NuclearExplosion explosion, double group) {
            return Math.sqrt(this.distance(explosion)) / group;
        }

        public void execute(NuclearExplosion explosion) {
        }
    }
}

