/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.util;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.util.EnergyHandler;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class ForgeEnergyHandler
implements EnergyHandler {
    public final LazyOptional<IEnergyStorage> optional;
    public final IEnergyStorage storage;

    public ForgeEnergyHandler(LazyOptional<IEnergyStorage> o, IEnergyStorage s) {
        this.optional = o;
        this.storage = s;
    }

    @Override
    public boolean isEnergyHandlerInvalid() {
        return !this.optional.isPresent();
    }

    @Override
    public double getEnergyCapacity() {
        return (double)this.storage.getMaxEnergyStored() / FTBICConfig.ZAP_TO_FE_CONVERSION_RATE;
    }

    @Override
    public double getEnergy() {
        return (double)this.storage.getEnergyStored() / FTBICConfig.ZAP_TO_FE_CONVERSION_RATE;
    }

    @Override
    public void setEnergyRaw(double e) {
        if (this.storage.getEnergyStored() <= 0 || this.storage.extractEnergy(this.storage.getEnergyStored(), false) > 0) {
            this.storage.receiveEnergy(MathHelper.func_76143_f((double)(e * FTBICConfig.ZAP_TO_FE_CONVERSION_RATE)), false);
        }
    }

    @Override
    public double insertEnergy(double maxInsert, boolean simulate) {
        return (double)this.storage.receiveEnergy(MathHelper.func_76143_f((double)(maxInsert * FTBICConfig.ZAP_TO_FE_CONVERSION_RATE)), simulate) / FTBICConfig.ZAP_TO_FE_CONVERSION_RATE;
    }
}

