/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.util.BurntBlockCondition;
import dev.ftb.mods.ftbic.util.EnergyItemHandler;
import dev.ftb.mods.ftbic.util.FTBChunksIntegration;
import dev.ftb.mods.ftbic.util.FTBChunksIntegrationImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class FTBICUtils {
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setLenient().create();
    public static final ITag.INamedTag<Block> REINFORCED = BlockTags.createOptional((ResourceLocation)new ResourceLocation("ftbic", "reinforced"));
    public static final ITag.INamedTag<Item> UNCANNABLE_FOOD = ItemTags.createOptional((ResourceLocation)new ResourceLocation("ftbic", "uncannable_food"));
    public static final ITag.INamedTag<Item> NO_AUTO_RECIPE = ItemTags.createOptional((ResourceLocation)new ResourceLocation("ftbic", "no_auto_recipe"));
    public static final LootConditionType BURNT_BLOCK = (LootConditionType)Registry.func_218322_a((Registry)Registry.field_239704_ba_, (ResourceLocation)new ResourceLocation("ftbic", "burnt_block"), (Object)new LootConditionType((ILootSerializer)new BurntBlockCondition.Serializer()));
    public static final Direction[] DIRECTIONS = Direction.values();
    public static final Direction[] HORIZONTAL_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};

    public static void init() {
        if (ModList.get().isLoaded("ftbchunks")) {
            FTBICUtils.initFTBChunks();
        }
    }

    private static void initFTBChunks() {
        FTBChunksIntegration.instance = new FTBChunksIntegrationImpl();
    }

    public static String formatEnergyValue(double energy) {
        return String.format("%,d", (long)energy);
    }

    public static StringTextComponent formatEnergy(double energy) {
        return (StringTextComponent)new StringTextComponent("").func_240702_b_(FTBICUtils.formatEnergyValue(energy) + " ").func_230529_a_(FTBICConfig.ENERGY_FORMAT);
    }

    public static ITextComponent energyTooltip(ItemStack stack, EnergyItemHandler itemHandler) {
        return new StringTextComponent("").func_230529_a_((ITextComponent)FTBICUtils.formatEnergy(itemHandler.getEnergy(stack)).func_240699_a_(TextFormatting.GRAY)).func_240702_b_(" / ").func_230529_a_((ITextComponent)FTBICUtils.formatEnergy(itemHandler.getEnergyCapacity(stack)).func_240699_a_(TextFormatting.GRAY)).func_240699_a_(TextFormatting.DARK_GRAY);
    }

    public static StringTextComponent formatHeat(int heat) {
        return (StringTextComponent)new StringTextComponent("").func_240702_b_(String.format("%,d ", heat)).func_230529_a_(FTBICConfig.HEAT_FORMAT);
    }

    public static <T> List<T> listFromJson(JsonObject json, String key, Function<JsonElement, T> function) {
        if (json.has(key)) {
            JsonArray array = json.get(key).getAsJsonArray();
            if (array.size() == 0) {
                return Collections.emptyList();
            }
            if (array.size() == 1) {
                return Collections.singletonList(function.apply(array.get(0)));
            }
            ArrayList<T> list = new ArrayList<T>(array.size());
            for (JsonElement e : array) {
                list.add(function.apply(e));
            }
            return list;
        }
        return Collections.emptyList();
    }

    public static <T> void listToJson(List<T> list, JsonObject json, String key, Function<T, JsonElement> function) {
        JsonArray array = new JsonArray();
        for (T obj : list) {
            array.add(function.apply(obj));
        }
        if (array.size() > 0) {
            json.add(key, (JsonElement)array);
        }
    }

    public static <T> List<T> listFromNet(PacketBuffer buf, Function<PacketBuffer, T> function) {
        int size = buf.func_150792_a();
        if (size == 0) {
            return Collections.emptyList();
        }
        if (size == 1) {
            return Collections.singletonList(function.apply(buf));
        }
        ArrayList<T> list = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            list.add(function.apply(buf));
        }
        return list;
    }

    public static <T> void listToNet(List<T> list, PacketBuffer buf, BiConsumer<T, PacketBuffer> function) {
        buf.func_150787_b(list.size());
        for (T obj : list) {
            function.accept(obj, buf);
        }
    }

    public static FluidStack fluidFromJson(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return FluidStack.EMPTY;
        }
        if (element.isJsonObject()) {
            JsonObject o = element.getAsJsonObject();
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(o.get("fluid").getAsString()));
            int amount = o.has("amount") ? o.get("amount").getAsInt() : 1000;
            return new FluidStack(fluid, amount);
        }
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(element.getAsString()));
        return new FluidStack(fluid, 1000);
    }

    public static JsonElement fluidToJson(FluidStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("fluid", stack.getFluid().getRegistryName().toString());
        json.addProperty("amount", (Number)stack.getAmount());
        return json;
    }

    public static int packInt(int value, int max) {
        if (value <= 30000) {
            return Math.max(value, 0);
        }
        if (value >= max) {
            return Short.MAX_VALUE;
        }
        return Math.min(value, 32000);
    }

    public static int unpackInt(int value, int max) {
        if (value <= 30000) {
            return value;
        }
        if (value == Short.MAX_VALUE) {
            return max;
        }
        return value;
    }
}

