/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.recipe;

import dev.ftb.mods.ftbic.recipe.MachineRecipe;
import dev.ftb.mods.ftbic.util.ItemKey;
import dev.ftb.mods.ftbic.util.MachineProcessingResult;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public abstract class MachineRecipeResults {
    private final Map<Object, MachineProcessingResult> cache = new HashMap<Object, MachineProcessingResult>();

    public MachineProcessingResult getResult(World level, ItemStack[] inputs, boolean checkCount) {
        int required = this.getRequiredItems();
        if (inputs.length < required) {
            return MachineProcessingResult.NONE;
        }
        Object key = this.createKey(inputs);
        MachineProcessingResult result = this.cache.get(key);
        if (result == null) {
            result = this.createResult(level, inputs);
            this.cache.put(key, result);
        }
        if (inputs.length < result.consume.length) {
            return MachineProcessingResult.NONE;
        }
        if (checkCount) {
            for (int i = 0; i < result.consume.length; ++i) {
                if (inputs[i].func_190916_E() >= result.consume[i]) continue;
                return MachineProcessingResult.NONE;
            }
        }
        return result;
    }

    public int getRequiredItems() {
        return 1;
    }

    public Object createKey(ItemStack[] inputs) {
        return new ItemKey(inputs[0]);
    }

    public abstract List<MachineRecipe> getAllRecipes(World var1);

    public abstract MachineProcessingResult createResult(World var1, ItemStack[] var2);

    public boolean canInsert(World level, int slot, ItemStack item) {
        return slot == 0 && this.getResult(level, new ItemStack[]{item}, false).exists();
    }

    public final List<MachineRecipe> getAllVisibleRecipes(World level) {
        return this.getAllRecipes(level).stream().filter(MachineRecipe::isVisibleJEI).collect(Collectors.toList());
    }

    public final List<MachineRecipe> getAllRealAndVisibleRecipes(World level) {
        return this.getAllRecipes(level).stream().filter(MachineRecipe::isRealAndVisibleJEI).collect(Collectors.toList());
    }
}

