/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.jei;

import dev.ftb.mods.ftbic.FTBIC;
import dev.ftb.mods.ftbic.block.FTBICElectricBlocks;
import dev.ftb.mods.ftbic.item.FTBICItems;
import dev.ftb.mods.ftbic.item.FluidCellItem;
import dev.ftb.mods.ftbic.jei.MachineRecipeCategory;
import dev.ftb.mods.ftbic.jei.PoweredCraftingTableTransferHandler;
import dev.ftb.mods.ftbic.recipe.FTBICRecipes;
import dev.ftb.mods.ftbic.recipe.RecipeCache;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

@JeiPlugin
public class FTBICJEIPlugin
implements IModPlugin {
    public static final ResourceLocation ID = new ResourceLocation("ftbic", "jei");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerItemSubtypes(ISubtypeRegistration r) {
        r.registerSubtypeInterpreter(FTBICItems.FLUID_CELL.get(), FluidCellItem::getSubtype);
        r.useNbtForSubtypes(new Item[]{FTBICItems.MECHANICAL_ELYTRA.get(), FTBICItems.CARBON_CHESTPLATE.get(), FTBICItems.QUANTUM_CHESTPLATE.get()});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration r) {
        r.addRecipeTransferHandler((IRecipeTransferHandler)new PoweredCraftingTableTransferHandler(), VanillaRecipeCategoryUid.CRAFTING);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration r) {
        r.addRecipeCatalyst((Object)new ItemStack((IItemProvider)FTBICItems.IRON_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
        r.addRecipeCatalyst((Object)new ItemStack((IItemProvider)FTBICItems.IRON_FURNACE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FUEL});
        r.addRecipeCatalyst((Object)new ItemStack((IItemProvider)FTBICElectricBlocks.POWERED_FURNACE.item.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
        r.addRecipeCatalyst((Object)new ItemStack((IItemProvider)FTBICElectricBlocks.POWERED_FURNACE.item.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FUEL});
        r.addRecipeCatalyst((Object)new ItemStack((IItemProvider)FTBICElectricBlocks.POWERED_FURNACE.item.get()), new ResourceLocation[]{FTBICRecipes.SMELTING.get().getRegistryName()});
        r.addRecipeCatalyst((Object)new ItemStack((IItemProvider)FTBICElectricBlocks.MACERATOR.item.get()), new ResourceLocation[]{FTBICRecipes.MACERATING.get().getRegistryName()});
        r.addRecipeCatalyst((Object)new ItemStack((IItemProvider)FTBICElectricBlocks.CENTRIFUGE.item.get()), new ResourceLocation[]{FTBICRecipes.SEPARATING.get().getRegistryName()});
        r.addRecipeCatalyst((Object)new ItemStack((IItemProvider)FTBICElectricBlocks.COMPRESSOR.item.get()), new ResourceLocation[]{FTBICRecipes.COMPRESSING.get().getRegistryName()});
        r.addRecipeCatalyst((Object)new ItemStack((IItemProvider)FTBICElectricBlocks.REPROCESSOR.item.get()), new ResourceLocation[]{FTBICRecipes.REPROCESSING.get().getRegistryName()});
        r.addRecipeCatalyst((Object)new ItemStack((IItemProvider)FTBICElectricBlocks.CANNING_MACHINE.item.get()), new ResourceLocation[]{FTBICRecipes.CANNING.get().getRegistryName()});
        r.addRecipeCatalyst((Object)new ItemStack((IItemProvider)FTBICElectricBlocks.ROLLER.item.get()), new ResourceLocation[]{FTBICRecipes.ROLLING.get().getRegistryName()});
        r.addRecipeCatalyst((Object)new ItemStack((IItemProvider)FTBICElectricBlocks.EXTRUDER.item.get()), new ResourceLocation[]{FTBICRecipes.EXTRUDING.get().getRegistryName()});
        r.addRecipeCatalyst((Object)new ItemStack((IItemProvider)FTBICElectricBlocks.ADVANCED_POWERED_FURNACE.item.get()), new ResourceLocation[]{FTBICRecipes.SMELTING.get().getRegistryName()});
        r.addRecipeCatalyst((Object)new ItemStack((IItemProvider)FTBICElectricBlocks.ADVANCED_POWERED_FURNACE.item.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FURNACE});
        r.addRecipeCatalyst((Object)new ItemStack((IItemProvider)FTBICElectricBlocks.ADVANCED_POWERED_FURNACE.item.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.FUEL});
        r.addRecipeCatalyst((Object)new ItemStack((IItemProvider)FTBICElectricBlocks.ADVANCED_MACERATOR.item.get()), new ResourceLocation[]{FTBICRecipes.MACERATING.get().getRegistryName()});
        r.addRecipeCatalyst((Object)new ItemStack((IItemProvider)FTBICElectricBlocks.ADVANCED_CENTRIFUGE.item.get()), new ResourceLocation[]{FTBICRecipes.SEPARATING.get().getRegistryName()});
        r.addRecipeCatalyst((Object)new ItemStack((IItemProvider)FTBICElectricBlocks.ADVANCED_COMPRESSOR.item.get()), new ResourceLocation[]{FTBICRecipes.COMPRESSING.get().getRegistryName()});
    }

    public void registerRecipes(IRecipeRegistration r) {
        RecipeCache cache;
        ClientWorld level = Minecraft.func_71410_x().field_71441_e;
        RecipeCache recipeCache = cache = level == null ? null : RecipeCache.get((World)Minecraft.func_71410_x().field_71441_e);
        if (cache == null) {
            FTBIC.LOGGER.error("Recipe cache not found for JEI plugin!");
            return;
        }
        r.addRecipes(cache.smelting.getAllRealAndVisibleRecipes((World)level), FTBICRecipes.SMELTING.get().getRegistryName());
        r.addRecipes(cache.macerating.getAllVisibleRecipes((World)level), FTBICRecipes.MACERATING.get().getRegistryName());
        r.addRecipes(cache.compressing.getAllVisibleRecipes((World)level), FTBICRecipes.COMPRESSING.get().getRegistryName());
        r.addRecipes(cache.separating.getAllVisibleRecipes((World)level), FTBICRecipes.SEPARATING.get().getRegistryName());
        r.addRecipes(cache.reprocessing.getAllVisibleRecipes((World)level), FTBICRecipes.REPROCESSING.get().getRegistryName());
        r.addRecipes(cache.canning.getAllVisibleRecipes((World)level), FTBICRecipes.CANNING.get().getRegistryName());
        r.addRecipes(cache.rolling.getAllVisibleRecipes((World)level), FTBICRecipes.ROLLING.get().getRegistryName());
        r.addRecipes(cache.extruding.getAllVisibleRecipes((World)level), FTBICRecipes.EXTRUDING.get().getRegistryName());
    }

    public void registerCategories(IRecipeCategoryRegistration r) {
        r.addRecipeCategories(new IRecipeCategory[]{new MachineRecipeCategory(FTBICRecipes.SMELTING, r.getJeiHelpers().getGuiHelper(), FTBICElectricBlocks.POWERED_FURNACE)});
        r.addRecipeCategories(new IRecipeCategory[]{new MachineRecipeCategory(FTBICRecipes.MACERATING, r.getJeiHelpers().getGuiHelper(), FTBICElectricBlocks.MACERATOR)});
        r.addRecipeCategories(new IRecipeCategory[]{new MachineRecipeCategory(FTBICRecipes.SEPARATING, r.getJeiHelpers().getGuiHelper(), FTBICElectricBlocks.CENTRIFUGE)});
        r.addRecipeCategories(new IRecipeCategory[]{new MachineRecipeCategory(FTBICRecipes.COMPRESSING, r.getJeiHelpers().getGuiHelper(), FTBICElectricBlocks.COMPRESSOR)});
        r.addRecipeCategories(new IRecipeCategory[]{new MachineRecipeCategory(FTBICRecipes.REPROCESSING, r.getJeiHelpers().getGuiHelper(), FTBICElectricBlocks.REPROCESSOR)});
        r.addRecipeCategories(new IRecipeCategory[]{new MachineRecipeCategory(FTBICRecipes.CANNING, r.getJeiHelpers().getGuiHelper(), FTBICElectricBlocks.CANNING_MACHINE)});
        r.addRecipeCategories(new IRecipeCategory[]{new MachineRecipeCategory(FTBICRecipes.ROLLING, r.getJeiHelpers().getGuiHelper(), FTBICElectricBlocks.ROLLER)});
        r.addRecipeCategories(new IRecipeCategory[]{new MachineRecipeCategory(FTBICRecipes.EXTRUDING, r.getJeiHelpers().getGuiHelper(), FTBICElectricBlocks.EXTRUDER)});
    }
}

