/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.item.reactor;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.item.reactor.ReactorItem;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class NuclearReactor {
    public final ItemStack[] inputItems;
    public boolean paused;
    public boolean simulation;
    public int heat;
    public double energyOutput;
    public int maxHeat;
    public double explosionModifier;
    public double explosionRadius;

    public NuclearReactor(ItemStack[] is) {
        this.inputItems = is;
        this.paused = true;
        this.simulation = false;
        this.energyOutput = 0.0;
        this.heat = 0;
    }

    public ItemStack getAt(int x, int y) {
        if (x < 0 || x >= 9 || y < 0 || y >= 6) {
            return ItemStack.field_190927_a;
        }
        return this.inputItems[x + y * 9];
    }

    public void setAt(int x, int y, ItemStack stack) {
        if (x < 0 || x >= 9 || y < 0 || y >= 6) {
            return;
        }
        this.inputItems[x + y * 9] = stack;
    }

    public void addHeat(int h) {
        this.heat = Math.max(this.heat + h, 0);
    }

    public void distributeHeat(ItemStack[] around, int heat) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(around.length);
        ItemStack first = ItemStack.field_190927_a;
        for (ItemStack stack : around) {
            if (!(stack.func_77973_b() instanceof ReactorItem) || !((ReactorItem)stack.func_77973_b()).isHeatAcceptor(stack)) continue;
            list.add(stack);
            if (first != ItemStack.field_190927_a) continue;
            first = stack;
        }
        if (list.isEmpty()) {
            this.addHeat(heat);
            return;
        }
        for (ItemStack stack : list) {
            ((ReactorItem)stack.func_77973_b()).damageReactorItem(stack, heat / list.size());
        }
        ((ReactorItem)first.func_77973_b()).damageReactorItem(first, heat % list.size());
    }

    public boolean tick() {
        ReactorItem reactorItem;
        ItemStack stack;
        int y;
        int x;
        this.energyOutput = 0.0;
        this.maxHeat = 10000;
        this.explosionModifier = 1.0;
        this.explosionRadius = FTBICConfig.NUCLEAR_REACTOR_EXPLOSION_BASE_RADIUS;
        boolean stopSimulation = true;
        for (x = 0; x < 9; ++x) {
            for (y = 0; y < 6; ++y) {
                stack = this.getAt(x, y);
                if (!(stack.func_77973_b() instanceof ReactorItem)) continue;
                reactorItem = (ReactorItem)stack.func_77973_b();
                reactorItem.reactorTickPre(this, stack, x, y);
                if (!stack.func_190926_b() && !reactorItem.isItemBroken(stack)) continue;
                this.setAt(x, y, ItemStack.field_190927_a);
            }
        }
        for (x = 0; x < 9; ++x) {
            for (y = 0; y < 6; ++y) {
                stack = this.getAt(x, y);
                if (!(stack.func_77973_b() instanceof ReactorItem)) continue;
                reactorItem = (ReactorItem)stack.func_77973_b();
                reactorItem.reactorTickPost(this, stack, x, y);
                if (!stack.func_190926_b() && !reactorItem.isItemBroken(stack)) continue;
                this.setAt(x, y, ItemStack.field_190927_a);
            }
        }
        for (x = 0; x < 9; ++x) {
            for (y = 0; y < 6; ++y) {
                stack = this.getAt(x, y);
                if (!(stack.func_77973_b() instanceof ReactorItem)) continue;
                reactorItem = (ReactorItem)stack.func_77973_b();
                if (stack.func_190926_b() || reactorItem.isItemBroken(stack)) {
                    this.setAt(x, y, ItemStack.field_190927_a);
                    continue;
                }
                if (!this.simulation || !reactorItem.keepSimulationRunning(stack)) continue;
                stopSimulation = false;
            }
        }
        this.heat = Math.max(0, this.heat);
        this.explosionRadius *= this.explosionModifier;
        this.explosionRadius = Math.min(this.explosionRadius, FTBICConfig.NUCLEAR_REACTOR_EXPLOSION_LIMIT);
        if (this.heat >= this.maxHeat) {
            stopSimulation = true;
        }
        return stopSimulation;
    }
}

