/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.item.reactor;

import dev.ftb.mods.ftbic.block.entity.generator.NuclearReactorBlockEntity;
import dev.ftb.mods.ftbic.item.reactor.BaseReactorItem;
import dev.ftb.mods.ftbic.item.reactor.NuclearReactor;
import dev.ftb.mods.ftbic.item.reactor.ReactorItem;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.Nullable;

public class HeatVentItem
extends BaseReactorItem {
    public final int selfCooling;
    public final int reactorCooling;
    public final int componentCooling;

    public HeatVentItem(int durability, int s, int h, int c) {
        super(durability);
        this.selfCooling = s;
        this.reactorCooling = h;
        this.componentCooling = c;
    }

    @Override
    public boolean isHeatAcceptor(ItemStack stack) {
        return stack.func_77958_k() > 0;
    }

    @Override
    public void reactorInfo(ItemStack stack, List<ITextComponent> list, boolean shift, boolean advanced, @Nullable NuclearReactor reactor, int x, int y) {
        if (stack.func_77958_k() > 0) {
            list.add((ITextComponent)new StringTextComponent("Coolant: ").func_230529_a_((ITextComponent)FTBICUtils.formatHeat(stack.func_77958_k() - stack.func_77952_i())).func_240699_a_(TextFormatting.GRAY));
        }
        list.add((ITextComponent)new StringTextComponent("Self Cooling: ").func_230529_a_((ITextComponent)FTBICUtils.formatHeat(this.selfCooling)).func_240702_b_("/s").func_240699_a_(TextFormatting.GRAY));
        list.add((ITextComponent)new StringTextComponent("Reactor Cooling: ").func_230529_a_((ITextComponent)FTBICUtils.formatHeat(this.reactorCooling)).func_240702_b_("/s").func_240699_a_(TextFormatting.GRAY));
        list.add((ITextComponent)new StringTextComponent("Component Cooling: ").func_230529_a_((ITextComponent)FTBICUtils.formatHeat(this.componentCooling)).func_240702_b_("/s").func_240699_a_(TextFormatting.GRAY));
    }

    @Override
    public void reactorTickPre(NuclearReactor reactor, ItemStack stack, int x, int y) {
        if (this.reactorCooling > 0) {
            reactor.addHeat(-this.reactorCooling);
        }
        if (this.selfCooling > 0) {
            this.damageReactorItem(stack, -this.selfCooling);
        }
        if (this.componentCooling > 0) {
            for (int i = 0; i < 4; ++i) {
                ItemStack is = reactor.getAt(x + NuclearReactorBlockEntity.OFFSET_X[i], y + NuclearReactorBlockEntity.OFFSET_Y[i]);
                if (!(is.func_77973_b() instanceof ReactorItem) || !((ReactorItem)is.func_77973_b()).isCoolant(is)) continue;
                ((ReactorItem)is.func_77973_b()).damageReactorItem(is, -this.componentCooling);
            }
        }
    }
}

