/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.item.reactor;

import dev.ftb.mods.ftbic.block.entity.generator.NuclearReactorBlockEntity;
import dev.ftb.mods.ftbic.item.reactor.BaseReactorItem;
import dev.ftb.mods.ftbic.item.reactor.NuclearReactor;
import dev.ftb.mods.ftbic.item.reactor.ReactorItem;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.Nullable;

public class HeatExchangerItem
extends BaseReactorItem {
    public final int heatTransferToAdjacent;
    public final int heatTransferToCore;

    public HeatExchangerItem(int durability, int a, int c) {
        super(durability);
        this.heatTransferToAdjacent = a;
        this.heatTransferToCore = c;
    }

    @Override
    public boolean isHeatAcceptor(ItemStack stack) {
        return stack.func_77958_k() > 0;
    }

    @Override
    public void reactorInfo(ItemStack stack, List<ITextComponent> list, boolean shift, boolean advanced, @Nullable NuclearReactor reactor, int x, int y) {
        if (stack.func_77958_k() > 0) {
            list.add((ITextComponent)new StringTextComponent("Coolant: ").func_230529_a_((ITextComponent)FTBICUtils.formatHeat(stack.func_77958_k() - stack.func_77952_i())).func_240699_a_(TextFormatting.GRAY));
        }
        list.add((ITextComponent)new StringTextComponent("Heat Transfer to Adjacent: ").func_230529_a_((ITextComponent)FTBICUtils.formatHeat(this.heatTransferToAdjacent)).func_240702_b_("/s").func_240699_a_(TextFormatting.GRAY));
        list.add((ITextComponent)new StringTextComponent("Heat Transfer to Core: ").func_230529_a_((ITextComponent)FTBICUtils.formatHeat(this.heatTransferToCore)).func_240702_b_("/s").func_240699_a_(TextFormatting.GRAY));
    }

    @Override
    public void reactorTickPre(NuclearReactor reactor, ItemStack stack, int x, int y) {
        int damage = 0;
        if (this.heatTransferToAdjacent > 0) {
            for (int i = 0; i < 4; ++i) {
                ItemStack is = reactor.getAt(x + NuclearReactorBlockEntity.OFFSET_X[i], y + NuclearReactorBlockEntity.OFFSET_Y[i]);
                if (!(is.func_77973_b() instanceof ReactorItem) || !((ReactorItem)is.func_77973_b()).isHeatAcceptor(is)) continue;
                ReactorItem heatableNeighbor = (ReactorItem)is.func_77973_b();
                double sh = this.getRelativeDamage(stack) * 100.0;
                double rh = heatableNeighbor.getRelativeDamage(is) * 100.0;
                int heat = this.getHeatTransfer(sh, rh, is.func_77958_k(), this.heatTransferToAdjacent);
                damage -= heat;
                damage += heatableNeighbor.damageReactorItem(is, heat);
            }
        }
        if (this.heatTransferToCore > 0) {
            double sh = this.getRelativeDamage(stack) * 100.0;
            double rh = (double)reactor.heat * 100.0 / (double)reactor.maxHeat;
            int heat = this.getHeatTransfer(sh, rh, reactor.maxHeat, this.heatTransferToCore);
            damage -= heat;
            reactor.addHeat(heat);
        }
        this.damageReactorItem(stack, damage);
    }

    private int getHeatTransfer(double sh, double rh, int max, int transfer) {
        double hh = rh + sh / 2.0;
        int add = Math.min(MathHelper.func_76128_c((double)((double)max * hh / 100.0)), transfer);
        if (hh < 0.25) {
            add = 1;
        } else if (hh < 0.5) {
            add = transfer / 8;
        } else if (hh < 0.75) {
            add = transfer / 4;
        } else if (hh < 1.0) {
            add = transfer / 2;
        }
        double frh = (double)MathHelper.func_76128_c((double)(rh * 10.0)) / 10.0;
        double fsh = (double)MathHelper.func_76128_c((double)(sh * 10.0)) / 10.0;
        if (frh > fsh) {
            add -= 2 * add;
        } else if (frh == fsh) {
            add = 0;
        }
        return add;
    }
}

