/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import dev.ftb.mods.ftbic.FTBIC;
import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.util.EnergyArmorMaterial;
import dev.ftb.mods.ftbic.util.EnergyItemHandler;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class EnergyArmorItem
extends ArmorItem
implements EnergyItemHandler {
    public EnergyArmorItem(EnergyArmorMaterial m) {
        super((IArmorMaterial)m, EquipmentSlotType.CHEST, new Item.Properties().func_200916_a(FTBIC.TAB));
    }

    public void damageEnergyItem(ItemStack stack, double amount) {
        double energy = this.getEnergy(stack);
        double e = Math.min(energy, amount);
        this.setEnergy(stack, energy - e);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        this.damageEnergyItem(stack, FTBICConfig.ARMOR_DAMAGE_ENERGY * (double)amount);
        return 0;
    }

    @Override
    public double getEnergyCapacity(ItemStack stack) {
        return ((EnergyArmorMaterial)this.field_200882_e).capacity;
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType s) {
        return ImmutableMultimap.of();
    }

    public boolean func_82789_a(ItemStack stack, ItemStack item) {
        return false;
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            list.add((Object)new ItemStack((IItemProvider)this));
            ItemStack full = new ItemStack((IItemProvider)this);
            this.setEnergyRaw(full, this.getEnergyCapacity(full));
            list.add((Object)full);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World level, List<ITextComponent> list, ITooltipFlag flag) {
        list.add(FTBICUtils.energyTooltip(stack, this));
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return this.field_200882_e == EnergyArmorMaterial.QUANTUM && this.getEnergy(stack) >= FTBICConfig.ARMOR_FLIGHT_ENERGY;
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        if (!entity.field_70170_p.field_72995_K) {
            this.damageEnergyItem(stack, FTBICConfig.ARMOR_FLIGHT_ENERGY);
        }
        if (flightTicks >= 3 && entity.func_213453_ef()) {
            Vector3d m = entity.func_213322_ci();
            double d = Math.max(Math.abs(m.field_72448_b), Math.max(Math.abs(m.field_72450_a), Math.abs(m.field_72449_c)));
            d = Math.min(d, 1.0);
            entity.func_213317_d(m.func_216372_d(d *= 0.91, d, d));
            this.damageEnergyItem(stack, FTBICConfig.ARMOR_FLIGHT_STOP);
        } else if (flightTicks >= 5 && entity.func_70051_ag()) {
            Vector3d v = entity.func_70040_Z();
            double d0 = 1.5;
            double d1 = 0.1;
            Vector3d m = entity.func_213322_ci();
            entity.func_213317_d(m.func_72441_c(v.field_72450_a * d1 + (v.field_72450_a * d0 - m.field_72450_a) * 0.5, v.field_72448_b * d1 + (v.field_72448_b * d0 - m.field_72448_b) * 0.5, v.field_72449_c * d1 + (v.field_72449_c * d0 - m.field_72449_c) * 0.5));
            this.damageEnergyItem(stack, FTBICConfig.ARMOR_FLIGHT_BOOST);
        }
        return true;
    }
}

