/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.item;

import dev.ftb.mods.ftbic.item.BatteryType;
import dev.ftb.mods.ftbic.item.ElectricItem;
import dev.ftb.mods.ftbic.util.EnergyItemHandler;
import dev.ftb.mods.ftbic.util.EnergyTier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;

public class BatteryItem
extends ElectricItem {
    public final BatteryType batteryType;

    public BatteryItem(BatteryType b, EnergyTier t, double cap) {
        super(t, cap);
        this.batteryType = b;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        CompoundNBT t;
        if (this.batteryType.singleUse && !(t = stack.func_196082_o()).func_74764_b("Energy")) {
            t.func_74780_a("Energy", this.capacity);
        }
        return null;
    }

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("Active");
    }

    @Override
    public boolean canInsertEnergy() {
        return !this.batteryType.singleUse;
    }

    @Override
    public boolean canExtractEnergy() {
        return true;
    }

    @Override
    public boolean isCreativeEnergyItem() {
        return this.batteryType.creative;
    }

    @Override
    public double extractEnergy(ItemStack stack, double maxExtract, boolean simulate) {
        double d = super.extractEnergy(stack, maxExtract, simulate);
        if (!simulate && this.getEnergy(stack) <= 0.0) {
            if (this.batteryType.singleUse) {
                stack.func_190918_g(1);
            } else {
                stack.func_196083_e("Energy");
            }
        }
        return d;
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("Active")) {
            stack.func_196083_e("Active");
        } else {
            stack.func_77983_a("Active", (INBT)ByteNBT.func_229672_a_((boolean)true));
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public void func_77663_a(ItemStack stack, World level, Entity entity, int slot, boolean bl) {
        if (entity instanceof LivingEntity && stack.func_77942_o() && stack.func_77978_p().func_74767_n("Active") && this.getEnergy(stack) > 0.0) {
            for (EquipmentSlotType equipmentSlot : EquipmentSlotType.values()) {
                ItemStack is = ((LivingEntity)entity).func_184582_a(equipmentSlot);
                if (is == stack || !(is.func_77973_b() instanceof EnergyItemHandler)) continue;
                EnergyItemHandler handler = (EnergyItemHandler)is.func_77973_b();
                double e = this.getEnergy(stack);
                if (!(e > 0.0)) break;
                double d = handler.insertEnergy(is, e, false);
                this.extractEnergy(stack, d, false);
            }
        }
    }
}

