/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.datagen;

import com.google.gson.JsonObject;
import dev.ftb.mods.ftbic.recipe.FTBICRecipes;
import dev.ftb.mods.ftbic.recipe.MachineRecipe;
import dev.ftb.mods.ftbic.recipe.MachineRecipeSerializer;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import dev.ftb.mods.ftbic.util.IngredientWithCount;
import dev.ftb.mods.ftbic.util.StackWithChance;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class MachineRecipeBuilder {
    private static final ResourceLocation DUMMY_ID = new ResourceLocation("ftbic", "dummy");
    private MachineRecipe recipe;
    private final Advancement.Builder advancement = Advancement.Builder.func_200278_a();

    public static MachineRecipeBuilder machine(Supplier<MachineRecipeSerializer> type) {
        MachineRecipeBuilder builder = new MachineRecipeBuilder();
        builder.recipe = new MachineRecipe(type.get(), DUMMY_ID);
        builder.recipe.realRecipe = true;
        builder.recipe.inputItems = new ArrayList<IngredientWithCount>(1);
        builder.recipe.inputFluids = new ArrayList<FluidStack>(0);
        builder.recipe.outputItems = new ArrayList<StackWithChance>(1);
        builder.recipe.outputFluids = new ArrayList<FluidStack>(0);
        return builder;
    }

    public static MachineRecipeBuilder macerating() {
        return MachineRecipeBuilder.machine(FTBICRecipes.MACERATING);
    }

    public static MachineRecipeBuilder separating() {
        return MachineRecipeBuilder.machine(FTBICRecipes.SEPARATING);
    }

    public static MachineRecipeBuilder compressing() {
        return MachineRecipeBuilder.machine(FTBICRecipes.COMPRESSING);
    }

    public static MachineRecipeBuilder canning() {
        return MachineRecipeBuilder.machine(FTBICRecipes.CANNING);
    }

    public static MachineRecipeBuilder rolling() {
        return MachineRecipeBuilder.machine(FTBICRecipes.ROLLING);
    }

    public static MachineRecipeBuilder extruding() {
        return MachineRecipeBuilder.machine(FTBICRecipes.EXTRUDING);
    }

    public MachineRecipeBuilder unlockedBy(String string, ICriterionInstance arg) {
        this.advancement.func_200275_a(string, arg);
        return this;
    }

    public MachineRecipeBuilder inputItem(Ingredient in, int count) {
        this.recipe.inputItems.add(new IngredientWithCount(in, count));
        return this;
    }

    public MachineRecipeBuilder inputItem(Ingredient in) {
        return this.inputItem(in, 1);
    }

    public MachineRecipeBuilder inputFluid(FluidStack stack) {
        this.recipe.inputFluids.add(stack);
        return this;
    }

    public MachineRecipeBuilder outputItem(ItemStack stack, double chance) {
        this.recipe.outputItems.add(new StackWithChance(stack, chance));
        return this;
    }

    public MachineRecipeBuilder outputItem(ItemStack stack) {
        return this.outputItem(stack, 1.0);
    }

    public MachineRecipeBuilder outputFluid(FluidStack stack) {
        this.recipe.outputFluids.add(stack);
        return this;
    }

    public MachineRecipeBuilder processingTime(double t) {
        this.recipe.processingTime = t;
        return this;
    }

    public MachineRecipeBuilder hideFromJEI() {
        this.recipe.hideFromJEI = true;
        return this;
    }

    public void save(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        this.advancement.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)RecipeUnlockedTrigger.func_235675_a_((ResourceLocation)id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        ItemStack result = this.recipe.func_77571_b();
        if (result.func_190926_b()) {
            consumer.accept(new Result(this, id, new ResourceLocation(id.func_110624_b(), "recipes/ftbic_machine/" + id.func_110623_a())));
        } else {
            consumer.accept(new Result(this, id, new ResourceLocation(id.func_110624_b(), "recipes/" + result.func_77973_b().func_77640_w().func_200300_c() + "/" + id.func_110623_a())));
        }
    }

    public static class Result
    implements IFinishedRecipe {
        private final MachineRecipeBuilder builder;
        private final ResourceLocation id;
        private final ResourceLocation advancementId;

        private Result(MachineRecipeBuilder b, ResourceLocation i, ResourceLocation a) {
            this.builder = b;
            this.id = i;
            this.advancementId = a;
        }

        public void func_218610_a(JsonObject json) {
            FTBICUtils.listToJson(((MachineRecipeBuilder)this.builder).recipe.inputItems, json, "inputItems", IngredientWithCount::toJson);
            FTBICUtils.listToJson(((MachineRecipeBuilder)this.builder).recipe.inputFluids, json, "inputFluids", FTBICUtils::fluidToJson);
            FTBICUtils.listToJson(((MachineRecipeBuilder)this.builder).recipe.outputItems, json, "outputItems", StackWithChance::toJson);
            FTBICUtils.listToJson(((MachineRecipeBuilder)this.builder).recipe.outputFluids, json, "outputFluids", FTBICUtils::fluidToJson);
            if (((MachineRecipeBuilder)this.builder).recipe.processingTime != 1.0) {
                json.addProperty("processingTime", (Number)((MachineRecipeBuilder)this.builder).recipe.processingTime);
            }
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return ((MachineRecipeBuilder)this.builder).recipe.serializer;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.builder.advancement.func_200273_b();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

