/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.datagen;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.data.ExistingFileHelper;

public abstract class CombinedTextureProvider
implements IDataProvider {
    private static final ExistingFileHelper.ResourceType TEXTURE = new ExistingFileHelper.ResourceType(ResourcePackType.CLIENT_RESOURCES, ".png", "textures");
    private final DataGenerator gen;
    private final String modid;
    private final ExistingFileHelper existingFileHelper;
    private final Map<ResourceLocation, TextureData> textureCache;
    private final Map<ResourceLocation, TextureData> map;

    public CombinedTextureProvider(DataGenerator g, String mod, ExistingFileHelper efh) {
        this.gen = g;
        this.modid = mod;
        this.existingFileHelper = efh;
        this.textureCache = new HashMap<ResourceLocation, TextureData>();
        this.map = new HashMap<ResourceLocation, TextureData>();
    }

    public ResourceLocation modLoc(String path) {
        return new ResourceLocation(this.modid, path);
    }

    public TextureData load(ResourceLocation id) {
        return this.textureCache.computeIfAbsent(id, id0 -> {
            TextureData textureData;
            block8: {
                InputStream stream = this.existingFileHelper.getResource(id0, ResourcePackType.CLIENT_RESOURCES, ".png", "textures").func_199027_b();
                try {
                    textureData = new TextureData(ImageIO.read(stream));
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
                stream.close();
            }
            return textureData;
        });
    }

    public void make(ResourceLocation path, TextureData data) {
        this.map.put(path, data);
    }

    public abstract void registerTextures();

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.registerTextures();
        for (Map.Entry<ResourceLocation, TextureData> entry : this.map.entrySet()) {
            TextureData data = entry.getValue();
            Path target = this.gen.func_200391_b().resolve("assets/" + entry.getKey().func_110624_b() + "/textures/" + entry.getKey().func_110623_a() + ".png");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)data.createBufferedImage(), "PNG", out);
            byte[] bytes = out.toByteArray();
            String hash = IDataProvider.field_208307_a.hashBytes(bytes).toString();
            if (!Objects.equals(cache.func_208323_a(target), hash) || !Files.exists(target, new LinkOption[0])) {
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                try (OutputStream outputStream = Files.newOutputStream(target, new OpenOption[0]);){
                    outputStream.write(bytes);
                }
            }
            cache.func_208316_a(target, hash);
            this.existingFileHelper.trackGenerated(entry.getKey(), (ExistingFileHelper.IResourceType)TEXTURE);
        }
    }

    public String func_200397_b() {
        return "CombinedTextures";
    }

    public static class TextureData {
        public final int width;
        public final int height;
        public final float[] pixels;

        public TextureData(int w, int h) {
            this.width = w;
            this.height = h;
            this.pixels = new float[w * h * 4];
        }

        public TextureData(BufferedImage image) {
            this.width = image.getWidth();
            this.height = image.getHeight();
            this.pixels = new float[this.width * this.height * 4];
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int i = (x + y * this.width) * 4;
                    int col = image.getRGB(x, y);
                    this.pixels[i] = (float)(col >> 24 & 0xFF) / 255.0f;
                    this.pixels[i + 1] = (float)(col >> 16 & 0xFF) / 255.0f;
                    this.pixels[i + 2] = (float)(col >> 8 & 0xFF) / 255.0f;
                    this.pixels[i + 3] = (float)(col >> 0 & 0xFF) / 255.0f;
                }
            }
        }

        public BufferedImage createBufferedImage() {
            BufferedImage image = new BufferedImage(this.width, this.height, 2);
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int i = (x + y * this.width) * 4;
                    int a = MathHelper.func_76125_a((int)((int)(this.pixels[i] * 255.0f)), (int)0, (int)255);
                    int r = MathHelper.func_76125_a((int)((int)(this.pixels[i + 1] * 255.0f)), (int)0, (int)255);
                    int g = MathHelper.func_76125_a((int)((int)(this.pixels[i + 2] * 255.0f)), (int)0, (int)255);
                    int b = MathHelper.func_76125_a((int)((int)(this.pixels[i + 3] * 255.0f)), (int)0, (int)255);
                    image.setRGB(x, y, a << 24 | r << 16 | g << 8 | b);
                }
            }
            return image;
        }

        public TextureData combine(TextureData data) {
            if (this.width != data.width || this.height != data.height) {
                BufferedImage dst = new BufferedImage(Math.max(this.width, data.width), Math.max(this.height, data.height), 2);
                BufferedImage src1 = this.createBufferedImage();
                BufferedImage src2 = data.createBufferedImage();
                Graphics2D g = (Graphics2D)dst.getGraphics();
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                g.drawImage(src1, 0, 0, dst.getWidth(), dst.getHeight(), null);
                g.drawImage(src2, 0, 0, dst.getWidth(), dst.getHeight(), null);
                return new TextureData(dst);
            }
            TextureData d = new TextureData(this.width, this.height);
            for (int i = 0; i < d.pixels.length; i += 4) {
                float a = data.pixels[i];
                d.pixels[i] = Math.min(this.pixels[i] + a, 1.0f);
                d.pixels[i + 1] = MathHelper.func_76131_a((float)MathHelper.func_219799_g((float)a, (float)this.pixels[i + 1], (float)data.pixels[i + 1]), (float)0.0f, (float)1.0f);
                d.pixels[i + 2] = MathHelper.func_76131_a((float)MathHelper.func_219799_g((float)a, (float)this.pixels[i + 2], (float)data.pixels[i + 2]), (float)0.0f, (float)1.0f);
                d.pixels[i + 3] = MathHelper.func_76131_a((float)MathHelper.func_219799_g((float)a, (float)this.pixels[i + 3], (float)data.pixels[i + 3]), (float)0.0f, (float)1.0f);
            }
            return d;
        }
    }
}

