/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import dev.ftb.mods.ftbic.block.ElectricBlock;
import dev.ftb.mods.ftbic.block.entity.machine.DiggingBaseBlockEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.BeaconTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;

public class DiggingBlockRenderer
extends TileEntityRenderer<DiggingBaseBlockEntity> {
    private static final ResourceLocation QUARRY_FRAME_TEXTURE = new ResourceLocation("ftbic", "textures/block/quarry_frame.png");
    private static final ResourceLocation QUARRY_MODEL_LIGHT_TEXTURE = new ResourceLocation("ftbic", "textures/block/quarry_model_light.png");
    private static final ResourceLocation QUARRY_MODEL_DARK_TEXTURE = new ResourceLocation("ftbic", "textures/block/quarry_model_dark.png");
    private final ModelRenderer quarryFrameWE = DiggingBlockRenderer.make(64, 32, 0, 0, -8.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f);
    private final ModelRenderer quarryFrameSN = DiggingBlockRenderer.make(64, 32, 22, 2, -1.0f, -1.0f, -8.0f, 2.0f, 2.0f, 16.0f);
    private final ModelRenderer quarryFrameW = DiggingBlockRenderer.make(64, 32, 0, 10, -8.0f, -1.0f, -1.0f, 7.0f, 2.0f, 2.0f);
    private final ModelRenderer quarryFrameE = DiggingBlockRenderer.make(64, 32, 0, 5, 1.0f, -1.0f, -1.0f, 7.0f, 2.0f, 2.0f);
    private final ModelRenderer quarryFrameS = DiggingBlockRenderer.make(64, 32, 19, 5, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, 7.0f);
    private final ModelRenderer quarryFrameN = DiggingBlockRenderer.make(64, 32, 44, 5, -1.0f, -1.0f, -8.0f, 2.0f, 2.0f, 7.0f);
    private final ModelRenderer quarryBar = DiggingBlockRenderer.make(64, 16, 0, 0, -8.0f, -1.0f, -1.0f, 16.0f, 2.0f, 2.0f);
    private final ModelRenderer quarryBarEnd = DiggingBlockRenderer.make(64, 16, 0, 10, -1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f);
    private final ModelRenderer quarryHead = DiggingBlockRenderer.make(64, 16, 32, 0, -4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f);

    private static ModelRenderer make(int tw, int th, int tx, int ty, float x, float y, float z, float w, float h, float d) {
        ModelRenderer part = new ModelRenderer(tw, th, tx, ty);
        part.func_228303_a_(x, y, z, w, h, d, 0.0f, false);
        return part;
    }

    public DiggingBlockRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    private int getLight(DiggingBaseBlockEntity entity, BlockPos.Mutable pos, double x, double y, double z) {
        World level = entity.func_145831_w();
        if (level == null) {
            return 0;
        }
        pos.func_189532_c((double)entity.func_174877_v().func_177958_n() + x, (double)entity.func_174877_v().func_177956_o() + y, (double)entity.func_174877_v().func_177952_p() + z);
        return WorldRenderer.func_228421_a_((IBlockDisplayReader)level, (BlockPos)pos);
    }

    public void render(DiggingBaseBlockEntity entity, float delta, MatrixStack matrices, IRenderTypeBuffer source, int light1, int overlay) {
        IVertexBuilder frameConsumer = source.getBuffer(RenderType.func_228638_b_((ResourceLocation)QUARRY_FRAME_TEXTURE));
        BlockPos.Mutable lpos = new BlockPos.Mutable();
        for (int x = 0; x < entity.sizeX; ++x) {
            matrices.func_227860_a_();
            matrices.func_227861_a_((double)(entity.offsetX + x) + 0.5, 0.5, (double)entity.offsetZ - 0.5);
            this.quarryFrameWE.func_228308_a_(matrices, frameConsumer, this.getLight(entity, lpos, entity.offsetX + x, 0.5, (double)entity.offsetZ - 0.5), overlay);
            matrices.func_227865_b_();
            matrices.func_227860_a_();
            matrices.func_227861_a_((double)(entity.offsetX + x) + 0.5, 0.5, (double)entity.offsetZ + 0.5 + (double)entity.sizeZ);
            this.quarryFrameWE.func_228308_a_(matrices, frameConsumer, this.getLight(entity, lpos, entity.offsetX + x, 0.5, (double)entity.offsetZ + 0.5 + (double)entity.sizeZ), overlay);
            matrices.func_227865_b_();
        }
        for (int z = 0; z < entity.sizeZ; ++z) {
            matrices.func_227860_a_();
            matrices.func_227861_a_((double)entity.offsetX - 0.5, 0.5, (double)(entity.offsetZ + z) + 0.5);
            this.quarryFrameSN.func_228308_a_(matrices, frameConsumer, this.getLight(entity, lpos, (double)entity.offsetX - 0.5, 0.5, entity.offsetZ + z), overlay);
            matrices.func_227865_b_();
            matrices.func_227860_a_();
            matrices.func_227861_a_((double)entity.offsetX + 0.5 + (double)entity.sizeX, 0.5, (double)(entity.offsetZ + z) + 0.5);
            this.quarryFrameSN.func_228308_a_(matrices, frameConsumer, this.getLight(entity, lpos, (double)entity.offsetX + 0.5 + (double)entity.sizeX, 0.5, entity.offsetZ + z), overlay);
            matrices.func_227865_b_();
        }
        int lightNW = this.getLight(entity, lpos, (double)entity.offsetX - 0.5, 0.5, (double)entity.offsetZ - 0.5);
        int lightNE = this.getLight(entity, lpos, (double)entity.offsetX + 0.5 + (double)entity.sizeX, 0.5, (double)entity.offsetZ - 0.5);
        int lightSW = this.getLight(entity, lpos, (double)entity.offsetX - 0.5, 0.5, (double)entity.offsetZ + 0.5 + (double)entity.sizeZ);
        int lightSE = this.getLight(entity, lpos, (double)entity.offsetX + 0.5 + (double)entity.sizeX, 0.5, (double)entity.offsetZ + 0.5 + (double)entity.sizeZ);
        matrices.func_227860_a_();
        matrices.func_227861_a_((double)entity.offsetX - 0.5, 0.5, (double)entity.offsetZ - 0.5);
        this.quarryFrameS.func_228308_a_(matrices, frameConsumer, lightNW, overlay);
        this.quarryFrameE.func_228308_a_(matrices, frameConsumer, lightNW, overlay);
        matrices.func_227865_b_();
        matrices.func_227860_a_();
        matrices.func_227861_a_((double)entity.offsetX + 0.5 + (double)entity.sizeX, 0.5, (double)entity.offsetZ - 0.5);
        this.quarryFrameS.func_228308_a_(matrices, frameConsumer, lightNE, overlay);
        this.quarryFrameW.func_228308_a_(matrices, frameConsumer, lightNE, overlay);
        matrices.func_227865_b_();
        matrices.func_227860_a_();
        matrices.func_227861_a_((double)entity.offsetX - 0.5, 0.5, (double)entity.offsetZ + 0.5 + (double)entity.sizeZ);
        this.quarryFrameN.func_228308_a_(matrices, frameConsumer, lightSW, overlay);
        this.quarryFrameE.func_228308_a_(matrices, frameConsumer, lightSW, overlay);
        matrices.func_227865_b_();
        matrices.func_227860_a_();
        matrices.func_227861_a_((double)entity.offsetX + 0.5 + (double)entity.sizeX, 0.5, (double)entity.offsetZ + 0.5 + (double)entity.sizeZ);
        this.quarryFrameN.func_228308_a_(matrices, frameConsumer, lightSE, overlay);
        this.quarryFrameW.func_228308_a_(matrices, frameConsumer, lightSE, overlay);
        matrices.func_227865_b_();
        IVertexBuilder modelConsumer = source.getBuffer(RenderType.func_228638_b_((ResourceLocation)((Boolean)entity.func_195044_w().func_177229_b((Property)ElectricBlock.DARK) != false ? QUARRY_MODEL_DARK_TEXTURE : QUARRY_MODEL_LIGHT_TEXTURE)));
        matrices.func_227860_a_();
        matrices.func_227861_a_((double)entity.offsetX - 0.5, 0.5, (double)entity.offsetZ - 0.5);
        this.quarryBarEnd.func_228308_a_(matrices, frameConsumer, lightNW, overlay);
        matrices.func_227865_b_();
        matrices.func_227860_a_();
        matrices.func_227861_a_((double)entity.offsetX + 0.5 + (double)entity.sizeX, 0.5, (double)entity.offsetZ - 0.5);
        this.quarryBarEnd.func_228308_a_(matrices, frameConsumer, lightNE, overlay);
        matrices.func_227865_b_();
        matrices.func_227860_a_();
        matrices.func_227861_a_((double)entity.offsetX - 0.5, 0.5, (double)entity.offsetZ + 0.5 + (double)entity.sizeZ);
        this.quarryBarEnd.func_228308_a_(matrices, frameConsumer, lightSW, overlay);
        matrices.func_227865_b_();
        matrices.func_227860_a_();
        matrices.func_227861_a_((double)entity.offsetX + 0.5 + (double)entity.sizeX, 0.5, (double)entity.offsetZ + 0.5 + (double)entity.sizeZ);
        this.quarryBarEnd.func_228308_a_(matrices, frameConsumer, lightSE, overlay);
        matrices.func_227865_b_();
        float lx = MathHelper.func_219799_g((float)delta, (float)entity.prevLaserX, (float)entity.laserX);
        float ly = entity.laserY - entity.func_174877_v().func_177956_o();
        float lz = MathHelper.func_219799_g((float)delta, (float)entity.prevLaserZ, (float)entity.laserZ);
        int headLight = this.getLight(entity, lpos, lx, 0.5, lz);
        matrices.func_227860_a_();
        matrices.func_227861_a_((double)lx, 0.5, (double)lz);
        this.quarryHead.func_228308_a_(matrices, modelConsumer, headLight, overlay);
        matrices.func_227865_b_();
        this.quarryBar.field_78796_g = 0.0f;
        for (int x = 0; x <= entity.sizeX; ++x) {
            matrices.func_227860_a_();
            matrices.func_227861_a_((double)(entity.offsetX + x), 0.5, (double)lz);
            this.quarryBar.func_228308_a_(matrices, modelConsumer, headLight, overlay);
            matrices.func_227865_b_();
        }
        this.quarryBar.field_78796_g = 1.5707964f;
        for (int z = 0; z <= entity.sizeZ; ++z) {
            matrices.func_227860_a_();
            matrices.func_227861_a_((double)lx, 0.5, (double)(entity.offsetZ + z));
            this.quarryBar.func_228308_a_(matrices, modelConsumer, headLight, overlay);
            matrices.func_227865_b_();
        }
        matrices.func_227860_a_();
        matrices.func_227861_a_((double)entity.offsetX - 0.5, 0.5, (double)lz);
        this.quarryBarEnd.func_228308_a_(matrices, modelConsumer, this.getLight(entity, lpos, (double)entity.offsetX - 0.5, 0.5, lz), overlay);
        matrices.func_227865_b_();
        matrices.func_227860_a_();
        matrices.func_227861_a_((double)entity.offsetX + 0.5 + (double)entity.sizeX, 0.5, (double)lz);
        this.quarryBarEnd.func_228308_a_(matrices, modelConsumer, this.getLight(entity, lpos, (double)entity.offsetX + 0.5 + (double)entity.sizeX, 0.5, lz), overlay);
        matrices.func_227865_b_();
        matrices.func_227860_a_();
        matrices.func_227861_a_((double)lx, 0.5, (double)entity.offsetZ - 0.5);
        this.quarryBarEnd.func_228308_a_(matrices, modelConsumer, this.getLight(entity, lpos, lx, 0.5, (double)entity.offsetZ - 0.5), overlay);
        matrices.func_227865_b_();
        matrices.func_227860_a_();
        matrices.func_227861_a_((double)lx, 0.5, (double)entity.offsetZ + 0.5 + (double)entity.sizeZ);
        this.quarryBarEnd.func_228308_a_(matrices, modelConsumer, this.getLight(entity, lpos, lx, 0.5, (double)entity.offsetZ + 0.5 + (double)entity.sizeZ), overlay);
        matrices.func_227865_b_();
        if (!entity.paused) {
            matrices.func_227860_a_();
            matrices.func_227861_a_((double)lx, (double)ly, (double)lz);
            DiggingBlockRenderer.renderBeaconBeam(matrices, source, delta, 1.0f, entity.func_145831_w().func_82737_E(), 0, -ly + 0.5f, entity.getLaserColor(), 0.2f, 0.25f);
            matrices.func_227865_b_();
        }
    }

    public static void renderBeaconBeam(MatrixStack matrices, IRenderTypeBuffer source, float delta, float g, long tick, int y, float height, float[] color, float h, float k) {
        float m = (float)y + height;
        matrices.func_227860_a_();
        float n = (float)Math.floorMod(-tick, 40L) + delta;
        float p = MathHelper.func_226164_h_((float)(n * 0.2f - (float)MathHelper.func_76141_d((float)(n * 0.1f))));
        float q = color[0];
        float r = color[1];
        float s = color[2];
        matrices.func_227860_a_();
        matrices.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(45.0f));
        float aj = -h;
        float aa = -h;
        float ap = -1.0f + p;
        float aq = height * g * (0.5f / h) + ap;
        DiggingBlockRenderer.renderPart(matrices, source.getBuffer(RenderType.func_228637_a_((ResourceLocation)BeaconTileEntityRenderer.field_147523_b, (boolean)false)), q, r, s, 1.0f, y, m, 0.0f, h, h, 0.0f, aj, 0.0f, 0.0f, aa, 0.0f, 1.0f, aq, ap);
        matrices.func_227865_b_();
        float af = -k;
        float ag = -k;
        float ai = -k;
        aj = -k;
        ap = -1.0f + p;
        aq = height * g + ap;
        DiggingBlockRenderer.renderPart(matrices, source.getBuffer(RenderType.func_228637_a_((ResourceLocation)BeaconTileEntityRenderer.field_147523_b, (boolean)true)), q, r, s, 0.125f, y, m, af, ag, k, ai, aj, k, k, k, 0.0f, 1.0f, aq, ap);
        matrices.func_227865_b_();
    }

    private static void renderPart(MatrixStack matrices, IVertexBuilder consumer, float f, float g, float h, float i, float j, float k, float l, float m, float n, float o, float p, float q, float r, float s, float t, float u, float v, float w) {
        MatrixStack.Entry lv = matrices.func_227866_c_();
        Matrix4f mp = lv.func_227870_a_();
        Matrix3f mn = lv.func_227872_b_();
        DiggingBlockRenderer.renderQuad(mp, mn, consumer, f, g, h, i, j, k, l, m, n, o, t, u, v, w);
        DiggingBlockRenderer.renderQuad(mp, mn, consumer, f, g, h, i, j, k, r, s, p, q, t, u, v, w);
        DiggingBlockRenderer.renderQuad(mp, mn, consumer, f, g, h, i, j, k, n, o, r, s, t, u, v, w);
        DiggingBlockRenderer.renderQuad(mp, mn, consumer, f, g, h, i, j, k, p, q, l, m, t, u, v, w);
    }

    private static void renderQuad(Matrix4f mp, Matrix3f mn, IVertexBuilder consumer, float f, float g, float h, float i, float j, float k, float l, float m, float n, float o, float p, float q, float r, float s) {
        DiggingBlockRenderer.addVertex(mp, mn, consumer, f, g, h, i, k, l, m, q, r);
        DiggingBlockRenderer.addVertex(mp, mn, consumer, f, g, h, i, j, l, m, q, s);
        DiggingBlockRenderer.addVertex(mp, mn, consumer, f, g, h, i, j, n, o, p, s);
        DiggingBlockRenderer.addVertex(mp, mn, consumer, f, g, h, i, k, n, o, p, r);
    }

    private static void addVertex(Matrix4f arg, Matrix3f arg2, IVertexBuilder arg3, float f, float g, float h, float i, float j, float k, float l, float m, float n) {
        arg3.func_227888_a_(arg, k, j, l).func_227885_a_(f, g, h, i).func_225583_a_(m, n).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(arg2, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    public boolean shouldRenderOffScreen(DiggingBaseBlockEntity entity) {
        return true;
    }
}

