/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.block.entity.machine;

import dev.ftb.mods.ftbic.FTBIC;
import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.FTBICElectricBlocks;
import dev.ftb.mods.ftbic.block.entity.ElectricBlockEntity;
import dev.ftb.mods.ftbic.util.TeleporterEntry;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class TeleporterBlockEntity
extends ElectricBlockEntity {
    public BlockPos linkedPos = null;
    public RegistryKey<World> linkedDimension = null;
    public String linkedName = null;
    public int warmup = 0;
    public int cooldown = 0;
    public boolean isPublic = false;
    public String name = "";

    public TeleporterBlockEntity() {
        super(FTBICElectricBlocks.TELEPORTER);
    }

    @Override
    public void writeData(CompoundNBT tag) {
        super.writeData(tag);
        if (this.linkedPos != null && this.linkedDimension != null) {
            tag.func_74768_a("LinkedX", this.linkedPos.func_177958_n());
            tag.func_74768_a("LinkedY", this.linkedPos.func_177956_o());
            tag.func_74768_a("LinkedZ", this.linkedPos.func_177952_p());
            tag.func_74778_a("LinkedDimension", this.linkedDimension.func_240901_a_().toString());
            tag.func_74778_a("LinkedName", this.linkedName);
        }
        if (this.warmup > 0) {
            tag.func_74768_a("Warmup", this.warmup);
        }
        if (this.cooldown > 0) {
            tag.func_74768_a("Cooldown", this.cooldown);
        }
        if (this.isPublic) {
            tag.func_74757_a("Public", true);
        }
        if (!this.name.isEmpty()) {
            tag.func_74778_a("Name", this.name);
        }
    }

    @Override
    public void readData(CompoundNBT tag) {
        super.readData(tag);
        this.linkedPos = null;
        this.linkedDimension = null;
        this.linkedName = "";
        if (tag.func_74764_b("LinkedDimension")) {
            this.linkedPos = new BlockPos(tag.func_74762_e("LinkedX"), tag.func_74762_e("LinkedY"), tag.func_74762_e("LinkedZ"));
            this.linkedDimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(tag.func_74779_i("LinkedDimension")));
            this.linkedName = tag.func_74779_i("LinkedName");
        }
        this.warmup = tag.func_74762_e("Warmup");
        this.cooldown = tag.func_74762_e("Cooldown");
        this.isPublic = tag.func_74767_n("Public");
        this.name = tag.func_74779_i("Name");
    }

    @Override
    public void writeNetData(CompoundNBT tag) {
        super.writeNetData(tag);
        if (!this.linkedName.isEmpty()) {
            tag.func_74778_a("LinkedName", this.linkedName);
        }
    }

    @Override
    public void readNetData(CompoundNBT tag) {
        super.readNetData(tag);
        this.linkedName = tag.func_74779_i("LinkedName");
    }

    @Override
    public void stepOn(ServerPlayerEntity player) {
        if (this.cooldown > 0 || this.linkedDimension == null || this.linkedPos == null) {
            return;
        }
        double use = this.getEnergyUse(this.linkedDimension, this.linkedPos);
        if (this.energy < use) {
            return;
        }
        ServerWorld linkedLevel = player.field_71133_b.func_71218_a(this.linkedDimension);
        if (linkedLevel != null && linkedLevel.func_195588_v(this.linkedPos)) {
            if (this.warmup < 10) {
                this.warmup += 2;
            } else {
                TileEntity entity = linkedLevel.func_175625_s(this.linkedPos);
                if (entity instanceof TeleporterBlockEntity) {
                    TeleporterBlockEntity t = (TeleporterBlockEntity)entity;
                    Direction direction = t.getFacing(Direction.NORTH);
                    this.energy -= use;
                    player.func_200619_a(linkedLevel, (double)this.linkedPos.func_177958_n() + 0.5, (double)this.linkedPos.func_177956_o() + 1.1, (double)this.linkedPos.func_177952_p() + 0.5, direction.func_185119_l() + 90.0f, 0.0f);
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187534_aX, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    this.field_145850_b.func_184148_a(null, player.func_226277_ct_(), player.func_226280_cw_(), player.func_226281_cx_(), SoundEvents.field_187534_aX, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    this.cooldown = 20;
                    this.warmup = 0;
                    this.func_70296_d();
                    t.cooldown = 60;
                    t.func_70296_d();
                    if (!this.linkedName.equals(t.name)) {
                        this.linkedName = t.name;
                        this.syncBlock();
                    }
                    FTBIC.LOGGER.debug(player.func_195047_I_() + " used teleporter to " + this.linkedDimension.func_240901_a_() + ":" + this.linkedPos);
                } else {
                    this.linkedName = "";
                    this.syncBlock();
                }
            }
        } else {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("block.ftbic.teleporter.load_error").func_240699_a_(TextFormatting.RED), true);
        }
    }

    @Override
    public void func_73660_a() {
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.warmup > 0) {
            --this.warmup;
        }
        if (this.cooldown <= 0 && this.linkedDimension != null && this.linkedPos != null && this.energy >= this.getEnergyUse(this.linkedDimension, this.linkedPos)) {
            this.active = true;
        }
        super.func_73660_a();
    }

    @Override
    public ActionResultType rightClick(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!this.field_145850_b.func_201670_d() && !this.placerId.equals(player.func_110124_au())) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("block.ftbic.teleporter.perm_error").func_240699_a_(TextFormatting.RED), true);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public boolean savePlacer() {
        return true;
    }

    public double getEnergyUse(RegistryKey<World> d, BlockPos p) {
        if (d != this.field_145850_b.func_234923_W_()) {
            return FTBICConfig.TELEPORTER_MAX_USE;
        }
        double mind = FTBICConfig.TELEPORTER_MIN_DISTANCE;
        double maxd = FTBICConfig.TELEPORTER_MAX_DISTANCE;
        double dx = p.func_177958_n() - this.field_174879_c.func_177958_n();
        double dz = p.func_177952_p() - this.field_174879_c.func_177952_p();
        double dist = MathHelper.func_151237_a((double)(dx * dx + dz * dz), (double)mind, (double)maxd);
        return MathHelper.func_219803_d((double)((dist - mind) / (maxd - mind)), (double)FTBICConfig.TELEPORTER_MIN_USE, (double)FTBICConfig.TELEPORTER_MAX_USE);
    }

    @Override
    public void writeMenu(ServerPlayerEntity player, PacketBuffer buf) {
        super.writeMenu(player, buf);
        ArrayList<TeleporterEntry> list = new ArrayList<TeleporterEntry>();
        for (TileEntity entity : this.field_145850_b.field_147482_g) {
            if (!(entity instanceof TeleporterBlockEntity)) continue;
            TeleporterBlockEntity teleporter = (TeleporterBlockEntity)entity;
            if (!teleporter.isPublic && !teleporter.placerId.equals(player.func_110124_au())) continue;
            list.add(new TeleporterEntry(teleporter, this.getEnergyUse((RegistryKey<World>)teleporter.field_145850_b.func_234923_W_(), teleporter.field_174879_c)));
        }
        buf.func_150787_b(list.size());
        for (TeleporterEntry e : list) {
            e.write(buf);
        }
    }

    public void select(ServerPlayerEntity player, RegistryKey<World> d, BlockPos p) {
        if (this.placerId.equals(player.func_110124_au())) {
            ServerWorld linkedLevel = player.field_71133_b.func_71218_a(d);
            if (linkedLevel != null && linkedLevel.func_195588_v(p)) {
                TileEntity entity = linkedLevel.func_175625_s(p);
                if (entity instanceof TeleporterBlockEntity) {
                    TeleporterBlockEntity t = (TeleporterBlockEntity)entity;
                    if (t.isPublic || t.placerId.equals(player.func_110124_au())) {
                        this.linkedDimension = d;
                        this.linkedPos = p;
                        this.linkedName = t.name;
                        this.syncBlock();
                    }
                } else {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("block.ftbic.teleporter.load_error").func_240699_a_(TextFormatting.RED), true);
                }
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("block.ftbic.teleporter.load_error").func_240699_a_(TextFormatting.RED), true);
            }
        } else {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("block.ftbic.teleporter.perm_error").func_240699_a_(TextFormatting.RED), true);
        }
    }
}

