/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.block.entity.machine;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.FTBICBlocks;
import dev.ftb.mods.ftbic.block.FTBICElectricBlocks;
import dev.ftb.mods.ftbic.block.entity.machine.DiggingBaseBlockEntity;
import dev.ftb.mods.ftbic.screen.QuarryMenu;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class QuarryBlockEntity
extends DiggingBaseBlockEntity {
    private static final Predicate<ItemEntity> ITEM_ENTITY_PREDICATE = entity -> true;
    private static final float[] LASER_COLOR = new float[]{1.0f, 0.1f, 0.1f};

    public QuarryBlockEntity() {
        super(FTBICElectricBlocks.QUARRY);
    }

    @Override
    public void initProperties() {
        super.initProperties();
        this.diggingMineTicks = FTBICConfig.QUARRY_MINE_TICKS;
        this.diggingMoveTicks = FTBICConfig.QUARRY_MOVE_TICKS;
    }

    @Override
    public boolean isValidBlock(BlockState state, BlockPos pos) {
        return state.func_185904_a().func_76230_c() && state.func_185887_b((IBlockReader)this.field_145850_b, pos) >= 0.0f;
    }

    @Override
    public void digBlock(BlockState state, BlockPos miningPos, double lx, double ly, double lz) {
        TileEntity minedEntity = state.hasTileEntity() ? this.field_145850_b.func_175625_s(miningPos) : null;
        LootContext.Builder lootContext = new LootContext.Builder((ServerWorld)this.field_145850_b).func_216023_a(this.field_145850_b.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)new Vector3d(lx, ly, lz)).func_216015_a(LootParameters.field_216289_i, (Object)new ItemStack((IItemProvider)Items.field_234756_kK_)).func_216015_a(LootParameters.field_216287_g, (Object)state).func_216021_b(LootParameters.field_216288_h, (Object)minedEntity);
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(state.func_215693_a(lootContext));
        this.field_145850_b.func_217377_a(miningPos, false);
        this.field_145850_b.func_217378_a(null, 2001, miningPos, Block.func_196246_j((BlockState)state));
        AxisAlignedBB aabb = new AxisAlignedBB(lx - 0.7, ly - 0.7, lz - 0.7, lx + 0.7, ly + 2.7, lz + 0.7);
        List itemEntities = this.field_145850_b.func_175647_a(ItemEntity.class, aabb, ITEM_ENTITY_PREDICATE);
        for (ItemEntity itemEntity : itemEntities) {
            list.add(itemEntity.func_92059_d());
            itemEntity.func_174812_G();
        }
        if (!list.isEmpty()) {
            this.ejectOutputItems();
            for (ItemStack stack : list) {
                ItemStack stack1 = this.addOutput(stack);
                if (stack1.func_190926_b()) continue;
                Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(this.getFacing(Direction.NORTH)), (ItemStack)stack1);
                this.paused = true;
            }
            this.ejectOutputItems();
        }
        for (Direction direction : FTBICUtils.DIRECTIONS) {
            if (direction == Direction.DOWN || this.field_145850_b.func_204610_c(miningPos.func_177972_a(direction)).func_206886_c() == Fluids.field_204541_a) continue;
            this.field_145850_b.func_180501_a(miningPos, FTBICBlocks.EXFLUID.get().func_176223_P(), 2);
            break;
        }
    }

    @Override
    public ActionResultType rightClick(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!this.field_145850_b.func_201670_d()) {
            if (player.func_213453_ef()) {
                this.paused = !this.paused;
                this.syncBlock();
            } else {
                this.openMenu((ServerPlayerEntity)player, (id, inventory) -> new QuarryMenu(id, inventory, this));
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public float[] getLaserColor() {
        return LASER_COLOR;
    }
}

