/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.block.entity.machine;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.FTBICBlocks;
import dev.ftb.mods.ftbic.block.FTBICElectricBlocks;
import dev.ftb.mods.ftbic.block.entity.machine.DiggingBaseBlockEntity;
import dev.ftb.mods.ftbic.screen.PumpMenu;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PumpBlockEntity
extends DiggingBaseBlockEntity
implements IFluidHandler,
IFluidTank {
    private static final float[] LASER_COLOR = new float[]{0.2f, 0.5f, 1.0f};
    public FluidStack fluidStack = FluidStack.EMPTY;
    public Fluid filter = Fluids.field_204541_a;

    public PumpBlockEntity() {
        super(FTBICElectricBlocks.PUMP);
    }

    @Override
    public void initProperties() {
        super.initProperties();
        this.diggingMineTicks = FTBICConfig.PUMP_MINE_TICKS;
        this.diggingMoveTicks = FTBICConfig.PUMP_MOVE_TICKS;
    }

    @Override
    public void writeData(CompoundNBT tag) {
        super.writeData(tag);
        tag.func_218657_a("Fluid", (INBT)this.fluidStack.writeToNBT(new CompoundNBT()));
        tag.func_74778_a("Filter", this.filter.getRegistryName().toString());
    }

    @Override
    public void readData(CompoundNBT tag) {
        super.readData(tag);
        this.fluidStack = FluidStack.loadFluidStackFromNBT((CompoundNBT)tag.func_74775_l("Fluid"));
        this.filter = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(tag.func_74779_i("Filter")));
    }

    @Override
    public boolean isValidBlock(BlockState state, BlockPos pos) {
        return state.func_185904_a().func_76224_d() && state.func_177230_c() instanceof IBucketPickupHandler && (this.filter == Fluids.field_204541_a || this.filter.func_207187_a(state.func_204520_s().func_206886_c())) && state.func_204520_s().func_206889_d();
    }

    @Override
    public void digBlock(BlockState state, BlockPos miningPos, double lx, double ly, double lz) {
        Fluid takeLiquid;
        if (state.func_177230_c() instanceof IBucketPickupHandler && this.fluidStack.getAmount() + 1000 <= this.getCapacity() && (takeLiquid = ((IBucketPickupHandler)state.func_177230_c()).func_204508_a((IWorld)this.field_145850_b, miningPos, state)) != Fluids.field_204541_a && takeLiquid.func_207193_c(takeLiquid.func_207188_f())) {
            if (this.filter == Fluids.field_204541_a) {
                this.filter = takeLiquid;
            }
            if (this.fluidStack.isEmpty()) {
                this.fluidStack = new FluidStack(this.filter, 1000);
            } else {
                this.fluidStack.setAmount(this.fluidStack.getAmount() + 1000);
            }
            this.field_145850_b.func_180501_a(miningPos, FTBICBlocks.EXFLUID.get().func_176223_P(), 2);
            this.func_70296_d();
        }
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this.getThisOptional().cast() : super.getCapability(cap, side);
    }

    @Override
    public ActionResultType rightClick(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!this.field_145850_b.func_201670_d()) {
            if (player.func_213453_ef()) {
                this.paused = !this.paused;
                this.syncBlock();
            } else {
                this.openMenu((ServerPlayerEntity)player, (id, inventory) -> new PumpMenu(id, inventory, this));
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public void writeMenu(ServerPlayerEntity player, PacketBuffer buf) {
        super.writeMenu(player, buf);
        buf.func_192572_a(this.filter.getRegistryName());
        this.fluidStack.writeToPacket(buf);
    }

    @Override
    public float[] getLaserColor() {
        return LASER_COLOR;
    }

    @NotNull
    public FluidStack getFluid() {
        return this.fluidStack;
    }

    public int getFluidAmount() {
        return this.fluidStack.getAmount();
    }

    public int getCapacity() {
        return FTBICConfig.PUMP_TANK_CAPACITY;
    }

    public boolean isFluidValid(FluidStack fluidStack) {
        return false;
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int i) {
        return this.fluidStack;
    }

    public int getTankCapacity(int i) {
        return FTBICConfig.PUMP_TANK_CAPACITY;
    }

    public boolean isFluidValid(int i, @NotNull FluidStack fluidStack) {
        return false;
    }

    public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        return 0;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.field_145850_b == null || this.field_145850_b.func_201670_d() || resource.isEmpty() || !resource.isFluidEqual(this.fluidStack)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.field_145850_b == null || this.field_145850_b.func_201670_d()) {
            return FluidStack.EMPTY;
        }
        int drained = maxDrain;
        if (this.fluidStack.getAmount() < drained) {
            drained = this.fluidStack.getAmount();
        }
        FluidStack stack = new FluidStack(this.fluidStack, drained);
        if (action.execute() && drained > 0) {
            this.fluidStack.shrink(drained);
            this.func_70296_d();
            if (this.fluidStack.isEmpty() && this.paused) {
                this.paused = false;
                this.syncBlock();
            }
        }
        return stack;
    }
}

