/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.block.entity.machine;

import com.google.gson.JsonElement;
import dev.ftb.mods.ftbic.FTBIC;
import dev.ftb.mods.ftbic.block.FTBICElectricBlocks;
import dev.ftb.mods.ftbic.block.entity.machine.BasicMachineBlockEntity;
import dev.ftb.mods.ftbic.screen.PoweredCraftingTableMenu;
import dev.ftb.mods.ftbic.screen.sync.SyncedData;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import java.util.Arrays;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import org.jetbrains.annotations.NotNull;

public class PoweredCraftingTableBlockEntity
extends BasicMachineBlockEntity {
    public final Ingredient[] ingredients = new Ingredient[9];
    private ResourceLocation matchedRecipe;
    public double progress;

    public PoweredCraftingTableBlockEntity() {
        super(FTBICElectricBlocks.POWERED_CRAFTING_TABLE);
        Arrays.fill(this.ingredients, Ingredient.field_193370_a);
    }

    @Override
    public void writeData(CompoundNBT tag) {
        super.writeData(tag);
        for (int i = 0; i < 9; ++i) {
            if (this.ingredients[i] == Ingredient.field_193370_a) continue;
            tag.func_74778_a("Ingredient" + (i + 1), FTBICUtils.GSON.toJson(this.ingredients[i].func_200304_c()));
        }
    }

    @Override
    public void readData(CompoundNBT tag) {
        super.readData(tag);
        Arrays.fill(this.ingredients, Ingredient.field_193370_a);
        for (int i = 0; i < 9; ++i) {
            String s = tag.func_74779_i("Ingredient" + (i + 1));
            this.ingredients[i] = s.isEmpty() ? Ingredient.field_193370_a : Ingredient.func_199802_a((JsonElement)((JsonElement)FTBICUtils.GSON.fromJson(s, JsonElement.class)));
        }
        this.matchedRecipe = null;
    }

    @Override
    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return slot >= 0 && slot < 9 && this.ingredients[slot] != Ingredient.field_193370_a && this.ingredients[slot].test(stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return slot < 9 ? 1 : 64;
    }

    @Override
    public void writeMenu(ServerPlayerEntity player, PacketBuffer buf) {
        super.writeMenu(player, buf);
        for (int i = 0; i < 9; ++i) {
            this.ingredients[i].func_199564_a(buf);
        }
    }

    @Override
    public void handleProcessing() {
        if (this.energy < this.energyUse) {
            return;
        }
        boolean hasRecipe = false;
        for (int i = 0; i < this.ingredients.length; ++i) {
            if (this.ingredients[i] == Ingredient.field_193370_a) {
                if (this.inputItems[i].func_190926_b()) continue;
                return;
            }
            hasRecipe = true;
            if (!this.inputItems[i].func_190926_b() && this.ingredients[i].test(this.inputItems[i])) continue;
            return;
        }
        if (!hasRecipe) {
            return;
        }
        this.progress += this.progressSpeed;
        this.energy -= this.energyUse;
        if (this.progress >= 100.0) {
            this.progress = 0.0;
            FTBIC.LOGGER.info("Success!");
            this.func_70296_d();
        }
    }

    @Override
    public ActionResultType rightClick(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!this.field_145850_b.func_201670_d()) {
            this.openMenu((ServerPlayerEntity)player, (id, inventory) -> new PoweredCraftingTableMenu(id, inventory, this));
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public void addSyncData(SyncedData data) {
        super.addSyncData(data);
        data.addShort(SyncedData.BAR, () -> MathHelper.func_76143_f((double)(this.progress * 22.0 / 100.0)));
    }
}

