/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.block.entity.machine;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.ElectricBlockInstance;
import dev.ftb.mods.ftbic.block.entity.machine.BasicMachineBlockEntity;
import dev.ftb.mods.ftbic.recipe.MachineRecipeResults;
import dev.ftb.mods.ftbic.recipe.MachineRecipeSerializer;
import dev.ftb.mods.ftbic.recipe.RecipeCache;
import dev.ftb.mods.ftbic.recipe.SimpleMachineRecipeResults;
import dev.ftb.mods.ftbic.screen.MachineMenu;
import dev.ftb.mods.ftbic.screen.sync.SyncedData;
import dev.ftb.mods.ftbic.util.MachineProcessingResult;
import java.util.Random;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MachineBlockEntity
extends BasicMachineBlockEntity {
    public double progress = 0.0;
    public double maxProgress = 0.0;
    public int acceleration = 0;
    private boolean checkProcessing = true;
    public boolean shouldAccelerate;

    public MachineBlockEntity(ElectricBlockInstance type) {
        super(type);
    }

    @Override
    public void writeData(CompoundNBT tag) {
        super.writeData(tag);
        tag.func_74780_a("MaxProgress", this.maxProgress);
        tag.func_74780_a("Progress", this.progress);
        if (this.acceleration > 0) {
            tag.func_74768_a("Acceleration", this.acceleration);
        }
    }

    @Override
    public void readData(CompoundNBT tag) {
        super.readData(tag);
        this.maxProgress = tag.func_74769_h("MaxProgress");
        this.progress = tag.func_74769_h("Progress");
        this.acceleration = tag.func_74762_e("Acceleration");
    }

    @Nullable
    private ItemStackHandler getOutput(MachineProcessingResult result, boolean simulate) {
        Random random;
        ItemStackHandler output = new ItemStackHandler(NonNullList.func_191197_a((int)this.outputItems.length, (Object)ItemStack.field_190927_a));
        for (int i = 0; i < this.outputItems.length; ++i) {
            output.setStackInSlot(i, this.outputItems[i].func_77946_l());
        }
        Random random2 = random = this.field_145850_b != null ? this.field_145850_b.field_73012_v : new Random();
        if ((simulate || random.nextDouble() < result.output.chance) && !ItemHandlerHelper.insertItemStacked((IItemHandler)output, (ItemStack)result.output.stack.func_77946_l(), (boolean)false).func_190926_b()) {
            return null;
        }
        for (int i = 0; i < result.extra.length; ++i) {
            if (!(result.extra[i].chance >= 1.0 ? !ItemHandlerHelper.insertItemStacked((IItemHandler)output, (ItemStack)result.extra[i].stack.func_77946_l(), (boolean)false).func_190926_b() : !simulate && random.nextDouble() < result.extra[i].chance && !ItemHandlerHelper.insertItemStacked((IItemHandler)output, (ItemStack)result.extra[i].stack.func_77946_l(), (boolean)false).func_190926_b())) continue;
            return null;
        }
        return output;
    }

    @Override
    public void handleProcessing() {
        if (this.isBurnt() || this.field_145850_b.func_201670_d()) {
            return;
        }
        if (this.maxProgress > 0.0 && this.progress < this.maxProgress) {
            int eu = MathHelper.func_76143_f((double)this.energyUse);
            if (eu > 0 && this.energy >= (double)eu) {
                this.progress += this.progressSpeed;
                this.energy -= (double)eu;
                this.active = true;
                if (this.energy < (double)eu) {
                    this.func_70296_d();
                }
                if (this.shouldAccelerate) {
                    ++this.acceleration;
                }
            }
            if (this.progress >= this.maxProgress) {
                ItemStackHandler out;
                this.progress = 0.0;
                this.func_70296_d();
                this.shiftInputs();
                MachineProcessingResult result = this.getResult(this.inputItems, true);
                if (result.exists() && (out = this.getOutput(result, false)) != null) {
                    int i;
                    for (i = 0; i < result.consume.length; ++i) {
                        this.inputItems[i].func_190918_g(result.consume[i]);
                        if (!this.inputItems[i].func_190926_b()) continue;
                        this.inputItems[i] = ItemStack.field_190927_a;
                    }
                    for (i = 0; i < this.outputItems.length; ++i) {
                        this.outputItems[i] = out.getStackInSlot(i);
                    }
                    this.shiftInputs();
                    this.ejectOutputItems();
                }
                this.checkProcessing = true;
            }
        }
        if (this.checkProcessing) {
            boolean hasResult;
            this.checkProcessing = false;
            MachineProcessingResult result = this.getResult(this.inputItems, true);
            boolean bl = hasResult = result.exists() && this.getOutput(result, true) != null;
            if (!hasResult) {
                this.progress = 0.0;
                this.maxProgress = 0.0;
                this.func_70296_d();
            } else if (this.progress <= 0.0) {
                this.maxProgress = result.time * FTBICConfig.MACHINE_RECIPE_BASE_TICKS;
                this.active = true;
                this.func_70296_d();
            }
        }
        if (this.acceleration > 0) {
            --this.acceleration;
            if (this.acceleration == 0) {
                this.func_70296_d();
            }
        }
    }

    @Override
    public void inventoryChanged(int slot, @Nullable ItemStack prev) {
        super.inventoryChanged(slot, prev);
        this.checkProcessing = true;
    }

    @Override
    public void energyChanged(int prev) {
        super.energyChanged(prev);
        if (this.energyUse != 0.0 && (double)prev < this.energyUse && this.energy >= this.energyUse) {
            this.checkProcessing = true;
        }
    }

    public abstract MachineRecipeResults getRecipes(RecipeCache var1);

    public MachineProcessingResult getResult(ItemStack[] items, boolean checkCount) {
        RecipeCache cache = this.getRecipeCache();
        return cache != null ? this.getRecipes(cache).getResult(this.field_145850_b, items, checkCount) : MachineProcessingResult.NONE;
    }

    @Override
    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        RecipeCache cache = this.getRecipeCache();
        return cache != null && this.getRecipes(cache).canInsert(this.field_145850_b, slot, stack);
    }

    @Nullable
    public MachineRecipeSerializer getRecipeSerializer() {
        RecipeCache cache = this.getRecipeCache();
        MachineRecipeResults results = cache == null ? null : this.getRecipes(cache);
        return results instanceof SimpleMachineRecipeResults ? ((SimpleMachineRecipeResults)results).recipeSerializer.get() : null;
    }

    @Override
    public ActionResultType rightClick(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!this.field_145850_b.func_201670_d()) {
            MachineRecipeSerializer serializer = this.getRecipeSerializer();
            if (serializer != null) {
                this.openMenu((ServerPlayerEntity)player, (id, inventory) -> new MachineMenu(id, inventory, this, serializer));
            } else {
                player.func_145747_a((ITextComponent)new StringTextComponent("No GUI yet!"), Util.field_240973_b_);
            }
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public void writeMenu(ServerPlayerEntity player, PacketBuffer buf) {
        super.writeMenu(player, buf);
        buf.func_192572_a(this.getRecipeSerializer().getRegistryName());
    }

    @Override
    public void addSyncData(SyncedData data) {
        super.addSyncData(data);
        data.addShort(SyncedData.BAR, () -> this.energyUse == 0.0 ? 0 : MathHelper.func_76125_a((int)MathHelper.func_76143_f((double)(this.progress * 24.0 / this.maxProgress)), (int)0, (int)24));
        data.addShort(SyncedData.ACCELERATION, () -> this.acceleration);
    }

    @Override
    public void initProperties() {
        super.initProperties();
        this.shouldAccelerate = false;
    }
}

