/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.block.entity.generator;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.FTBICElectricBlocks;
import dev.ftb.mods.ftbic.block.entity.generator.GeneratorBlockEntity;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class WindMillBlockEntity
extends GeneratorBlockEntity {
    private int blocksInRadius = -1;
    public double output = 0.0;

    public WindMillBlockEntity() {
        super(FTBICElectricBlocks.WIND_MILL);
    }

    @Override
    public void handleGeneration() {
        this.output = 0.0;
        if (this.energy < this.energyCapacity && this.field_145850_b.func_226660_f_(this.field_174879_c.func_177984_a())) {
            int height;
            if (this.field_145850_b.func_82737_E() % 1200L == 0L) {
                this.blocksInRadius = -1;
            }
            if (this.blocksInRadius == -1) {
                this.blocksInRadius = 0;
                for (int x = -5; x <= 5; ++x) {
                    for (int z = -5; z <= 5; ++z) {
                        for (int y = -2; y <= 5; ++y) {
                            if (y <= 0 && x == 0 && z == 0 || this.field_145850_b.func_175623_d(this.field_174879_c.func_177982_a(x, y, z))) continue;
                            ++this.blocksInRadius;
                        }
                    }
                }
            }
            if ((height = this.field_174879_c.func_177956_o() - this.blocksInRadius) < FTBICConfig.WIND_MILL_MIN_Y) {
                return;
            }
            if (height > FTBICConfig.WIND_MILL_MAX_Y) {
                height = FTBICConfig.WIND_MILL_MAX_Y;
            }
            this.output = MathHelper.func_219803_d((double)((double)height / (double)(FTBICConfig.WIND_MILL_MAX_Y - FTBICConfig.WIND_MILL_MIN_Y)), (double)FTBICConfig.WIND_MILL_MIN_OUTPUT, (double)FTBICConfig.WIND_MILL_MAX_OUTPUT);
            if (this.output <= 0.0) {
                return;
            }
            if (this.field_145850_b.func_72911_I()) {
                this.output *= FTBICConfig.WIND_MILL_THUNDER_MODIFIER;
            } else if (this.field_145850_b.func_72896_J()) {
                this.output *= FTBICConfig.WIND_MILL_RAIN_MODIFIER;
            }
            this.energy += Math.min(this.energyCapacity - this.energy, this.output);
            if (this.energy >= this.energyCapacity) {
                this.func_70296_d();
            }
        }
    }

    @Override
    public ActionResultType rightClick(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!this.field_145850_b.func_201670_d()) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("ftbic.output", new Object[]{FTBICUtils.formatEnergy(this.output)}), false);
        }
        return ActionResultType.SUCCESS;
    }
}

