/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.block.entity.generator;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.entity.generator.GeothermalGeneratorBlockEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class GeothermalGeneratorTank
implements IFluidHandler,
IFluidTank {
    public final GeothermalGeneratorBlockEntity generator;

    public GeothermalGeneratorTank(GeothermalGeneratorBlockEntity g) {
        this.generator = g;
    }

    @NotNull
    public FluidStack getFluid() {
        return this.generator.fluidAmount == 0 ? FluidStack.EMPTY : new FluidStack((Fluid)Fluids.field_204547_b, this.generator.fluidAmount);
    }

    public int getFluidAmount() {
        return this.generator.fluidAmount;
    }

    public int getCapacity() {
        return FTBICConfig.GEOTHERMAL_GENERATOR_TANK_SIZE;
    }

    public boolean isFluidValid(FluidStack fluidStack) {
        return fluidStack.getFluid() == Fluids.field_204547_b;
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int i) {
        return this.getFluid();
    }

    public int getTankCapacity(int i) {
        return FTBICConfig.GEOTHERMAL_GENERATOR_TANK_SIZE;
    }

    public boolean isFluidValid(int i, @NotNull FluidStack fluidStack) {
        return this.isFluidValid(fluidStack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!resource.isEmpty() && this.isFluidValid(resource)) {
            int filled = Math.min(this.getCapacity() - this.generator.fluidAmount, resource.getAmount());
            if (filled > 0 && !action.simulate()) {
                this.generator.fluidAmount += filled;
                this.generator.func_70296_d();
            }
            return filled;
        }
        return 0;
    }

    @NotNull
    public FluidStack drain(int amount, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }
}

