/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.block.entity.generator;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.BurntCableBlock;
import dev.ftb.mods.ftbic.block.CableBlock;
import dev.ftb.mods.ftbic.block.ElectricBlockInstance;
import dev.ftb.mods.ftbic.block.entity.ElectricBlockEntity;
import dev.ftb.mods.ftbic.block.entity.machine.BatteryInventory;
import dev.ftb.mods.ftbic.util.CachedEnergyStorage;
import dev.ftb.mods.ftbic.util.CachedEnergyStorageOrigin;
import dev.ftb.mods.ftbic.util.EnergyHandler;
import dev.ftb.mods.ftbic.util.EnergyItemHandler;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import dev.ftb.mods.ftbic.util.ForgeEnergyHandler;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class GeneratorBlockEntity
extends ElectricBlockEntity {
    private long currentElectricNetwork = -1L;
    private CachedEnergyStorage[] connectedEnergyBlocks;
    public final BatteryInventory chargeBatteryInventory = new BatteryInventory(this, true);
    public double maxEnergyOutput;
    public double maxEnergyOutputTransfer;

    public GeneratorBlockEntity(ElectricBlockInstance type) {
        super(type);
    }

    @Override
    public void initProperties() {
        super.initProperties();
        this.maxEnergyOutput = this.electricBlockInstance.maxEnergyOutput;
        this.maxEnergyOutputTransfer = FTBICConfig.LV_TRANSFER_RATE;
    }

    @Override
    public void writeData(CompoundNBT tag) {
        super.writeData(tag);
        if (!this.chargeBatteryInventory.getStackInSlot(0).func_190926_b()) {
            tag.func_218657_a("ChargeBattery", (INBT)this.chargeBatteryInventory.getStackInSlot(0).serializeNBT());
        }
    }

    @Override
    public void readData(CompoundNBT tag) {
        super.readData(tag);
        if (tag.func_74764_b("ChargeBattery")) {
            this.chargeBatteryInventory.loadItem(ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("ChargeBattery")));
        } else {
            this.chargeBatteryInventory.loadItem(ItemStack.field_190927_a);
        }
    }

    @Override
    public void onBroken(World level, BlockPos pos) {
        super.onBroken(level, pos);
        Block.func_180635_a((World)level, (BlockPos)pos, (ItemStack)this.chargeBatteryInventory.getStackInSlot(0));
    }

    public void handleEnergyOutput() {
        double tenergy;
        double transfer;
        EnergyItemHandler item;
        double e;
        ItemStack battery;
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        if (this.energy > 0.0 && !(battery = this.chargeBatteryInventory.getStackInSlot(0)).func_190926_b() && battery.func_77973_b() instanceof EnergyItemHandler && (e = item.insertEnergy(battery, Math.min(this.energy, transfer = (item = (EnergyItemHandler)battery.func_77973_b()).isCreativeEnergyItem() ? Double.POSITIVE_INFINITY : this.maxEnergyOutputTransfer * FTBICConfig.ITEM_TRANSFER_EFFICIENCY), false)) > 0.0) {
            this.energy -= e;
            this.active = true;
            this.func_70296_d();
        }
        if ((tenergy = Math.min(this.energy, this.maxEnergyOutputTransfer)) <= 0.0) {
            return;
        }
        CachedEnergyStorage[] blocks = this.getConnectedEnergyBlocks();
        int validBlocks = 0;
        for (CachedEnergyStorage storage : blocks) {
            if (storage.isInvalid()) {
                GeneratorBlockEntity.electricNetworkUpdated((IWorld)this.field_145850_b, storage.blockEntity.func_174877_v());
                continue;
            }
            if (!storage.shouldReceiveEnergy()) continue;
            ++validBlocks;
        }
        if (validBlocks > 0) {
            e = tenergy / (double)validBlocks;
            for (CachedEnergyStorage storage : blocks) {
                if (storage.isInvalid() || !storage.shouldReceiveEnergy()) continue;
                if (storage.origin.cableTier != null && storage.origin.cableTier.transferRate < e) {
                    this.field_145850_b.func_180501_a(storage.origin.cablePos, BurntCableBlock.getBurntCable(this.field_145850_b.func_180495_p(storage.origin.cablePos)), 3);
                    this.field_145850_b.func_217379_c(1502, storage.origin.cablePos, 0);
                    storage.origin.cableBurnt = true;
                    continue;
                }
                double a = storage.energyHandler.insertEnergy(Math.min(e, this.energy), false);
                if (a > 0.0) {
                    this.energy -= a;
                    this.active = true;
                    this.func_70296_d();
                }
                if (this.energy < e) break;
            }
        }
    }

    public void handleGeneration() {
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.func_201670_d()) {
            this.handleGeneration();
        }
        this.handleEnergyOutput();
        this.handleChanges();
    }

    public boolean isValidEnergyOutputSide(Direction direction) {
        return true;
    }

    @Override
    public boolean isValidEnergyInputSide(Direction direction) {
        return false;
    }

    public CachedEnergyStorage[] getConnectedEnergyBlocks() {
        if (this.field_145850_b == null || this.field_145850_b.func_201670_d()) {
            return CachedEnergyStorage.EMPTY;
        }
        long currentId = GeneratorBlockEntity.getCurrentElectricNetwork((IWorld)this.field_145850_b, this.func_174877_v());
        if (this.connectedEnergyBlocks == null || this.currentElectricNetwork == -1L || this.currentElectricNetwork != currentId) {
            HashSet<CachedEnergyStorage> set = new HashSet<CachedEnergyStorage>();
            HashSet<BlockPos> traversed = new HashSet<BlockPos>();
            traversed.add(this.field_174879_c);
            for (Direction direction : FTBICUtils.DIRECTIONS) {
                if (!this.isValidEnergyOutputSide(direction)) continue;
                CachedEnergyStorageOrigin origin = new CachedEnergyStorageOrigin();
                origin.direction = direction;
                this.find(traversed, set, origin, 0, this.field_174879_c, direction);
            }
            this.connectedEnergyBlocks = set.toArray(CachedEnergyStorage.EMPTY);
            this.currentElectricNetwork = currentId;
        }
        return this.connectedEnergyBlocks;
    }

    private void find(Set<BlockPos> traversed, Set<CachedEnergyStorage> set, CachedEnergyStorageOrigin origin, int distance, BlockPos currentPos, Direction direction) {
        if (this.field_145850_b == null || distance > FTBICConfig.MAX_CABLE_LENGTH) {
            return;
        }
        BlockPos pos = currentPos.func_177972_a(direction);
        if (!traversed.add(pos)) {
            return;
        }
        BlockState state = this.field_145850_b.func_180495_p(pos);
        if (state.func_177230_c() instanceof CableBlock) {
            CableBlock cableBlock = (CableBlock)state.func_177230_c();
            if (origin.cableTier == null || cableBlock.tier.transferRate < origin.cableTier.transferRate) {
                origin.cableTier = cableBlock.tier;
                origin.cablePos = pos;
            }
            for (Direction dir : FTBICUtils.DIRECTIONS) {
                if (!((Boolean)state.func_177229_b((Property)CableBlock.CONNECTION[dir.func_176745_a()])).booleanValue()) continue;
                this.find(traversed, set, origin, distance + 1, pos, dir);
            }
        } else if (state.hasTileEntity()) {
            LazyOptional energyCap;
            IEnergyStorage feStorage;
            EnergyHandler handler;
            TileEntity entity = this.field_145850_b.func_175625_s(pos);
            EnergyHandler energyHandler = handler = entity instanceof EnergyHandler ? (EnergyHandler)entity : null;
            if (handler != null) {
                if (handler != this && handler.getMaxInputEnergy() > 0.0 && !handler.isBurnt() && handler.isValidEnergyInputSide(direction.func_176734_d())) {
                    CachedEnergyStorage s = new CachedEnergyStorage();
                    s.origin = origin;
                    s.distance = distance;
                    s.blockEntity = entity;
                    s.energyHandler = handler;
                    set.add(s);
                }
            } else if (FTBICConfig.ZAP_TO_FE_CONVERSION_RATE > 0.0 && (feStorage = (IEnergyStorage)(energyCap = entity.getCapability(CapabilityEnergy.ENERGY, direction.func_176734_d())).orElse(null)) != null && feStorage.canReceive()) {
                CachedEnergyStorage s = new CachedEnergyStorage();
                s.origin = origin;
                s.distance = distance;
                s.blockEntity = entity;
                s.energyHandler = new ForgeEnergyHandler((LazyOptional<IEnergyStorage>)energyCap, feStorage);
                set.add(s);
            }
        }
    }
}

