/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.block.entity.generator;

import dev.ftb.mods.ftbic.block.FTBICElectricBlocks;
import dev.ftb.mods.ftbic.block.entity.generator.GeneratorBlockEntity;
import dev.ftb.mods.ftbic.recipe.RecipeCache;
import dev.ftb.mods.ftbic.screen.BasicGeneratorMenu;
import dev.ftb.mods.ftbic.screen.sync.SyncedData;
import dev.ftb.mods.ftbic.screen.sync.SyncedDataKey;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import org.jetbrains.annotations.NotNull;

public class BasicGeneratorBlockEntity
extends GeneratorBlockEntity {
    public static final SyncedDataKey<Integer> FUEL_BAR = new SyncedDataKey<Integer>("fuel_ticks", 0);
    public int fuelTicks = 0;
    public int maxFuelTicks = 0;

    public BasicGeneratorBlockEntity() {
        super(FTBICElectricBlocks.BASIC_GENERATOR);
    }

    @Override
    public void writeData(CompoundNBT tag) {
        super.writeData(tag);
        tag.func_74768_a("FuelTicks", this.fuelTicks);
        tag.func_74768_a("MaxFuelTicks", this.maxFuelTicks);
    }

    @Override
    public void readData(CompoundNBT tag) {
        super.readData(tag);
        this.fuelTicks = tag.func_74762_e("FuelTicks");
        this.maxFuelTicks = tag.func_74762_e("MaxFuelTicks");
    }

    @Override
    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        if (slot == 0) {
            RecipeCache recipeCache = this.getRecipeCache();
            return recipeCache != null && recipeCache.getBasicGeneratorFuelTicks(this.field_145850_b, stack) > 0;
        }
        return false;
    }

    @Override
    public void handleGeneration() {
        RecipeCache recipeCache;
        if (this.fuelTicks > 0) {
            --this.fuelTicks;
            if (this.energy < this.energyCapacity) {
                this.energy += Math.min(this.energyCapacity - this.energy, this.maxEnergyOutput);
            }
            if (this.fuelTicks == 0) {
                this.func_70296_d();
            }
        }
        if (this.fuelTicks == 0 && this.energy < this.energyCapacity && !this.inputItems[0].func_190926_b() && (recipeCache = this.getRecipeCache()) != null) {
            this.fuelTicks = this.maxFuelTicks = recipeCache.getBasicGeneratorFuelTicks(this.field_145850_b, this.inputItems[0]);
            if (this.maxFuelTicks > 0) {
                if (this.inputItems[0].func_190916_E() == 1) {
                    this.inputItems[0] = this.inputItems[0].getContainerItem();
                } else {
                    this.inputItems[0].func_190918_g(1);
                }
                this.active = true;
                this.func_70296_d();
            }
        }
    }

    @Override
    public ActionResultType rightClick(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!this.field_145850_b.func_201670_d()) {
            this.openMenu((ServerPlayerEntity)player, (id, inventory) -> new BasicGeneratorMenu(id, inventory, this));
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public void addSyncData(SyncedData data) {
        super.addSyncData(data);
        data.addShort(SyncedData.BAR, () -> this.fuelTicks == 0 ? 0 : MathHelper.func_76125_a((int)MathHelper.func_76143_f((double)((double)this.fuelTicks * 14.0 / (double)this.maxFuelTicks)), (int)0, (int)14));
    }
}

