/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic.block.entity;

import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.ElectricBlock;
import dev.ftb.mods.ftbic.block.ElectricBlockInstance;
import dev.ftb.mods.ftbic.recipe.RecipeCache;
import dev.ftb.mods.ftbic.screen.sync.SyncedData;
import dev.ftb.mods.ftbic.util.EnergyHandler;
import dev.ftb.mods.ftbic.util.OpenMenuFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElectricBlockEntity
extends TileEntity
implements ITickableTileEntity,
EnergyHandler,
IItemHandlerModifiable {
    private static final AtomicLong ELECTRIC_NETWORK_CHANGES = new AtomicLong(0L);
    public final ElectricBlockInstance electricBlockInstance;
    private boolean changed;
    public double energy;
    public final ItemStack[] inputItems;
    public final ItemStack[] outputItems;
    private LazyOptional<?> thisOptional;
    public boolean active;
    private int changeStateTicks;
    private boolean burnt;
    public double energyCapacity;
    public double maxInputEnergy;
    public boolean autoEject;
    public UUID placerId = Util.field_240973_b_;
    public String placerName = "";

    public static void electricNetworkUpdated(IWorld level, BlockPos pos) {
        ELECTRIC_NETWORK_CHANGES.incrementAndGet();
    }

    public static long getCurrentElectricNetwork(IWorld level, BlockPos pos) {
        return ELECTRIC_NETWORK_CHANGES.get();
    }

    public ElectricBlockEntity(ElectricBlockInstance type) {
        super(type.blockEntity.get());
        this.electricBlockInstance = type;
        this.changed = false;
        this.energy = 0.0;
        this.inputItems = new ItemStack[type.inputItemCount];
        this.outputItems = new ItemStack[type.outputItemCount];
        Arrays.fill(this.inputItems, ItemStack.field_190927_a);
        Arrays.fill(this.outputItems, ItemStack.field_190927_a);
        if (this.inputItems.length + this.outputItems.length > 127) {
            throw new RuntimeException("Internal inventory of " + this.func_200662_C().getRegistryName() + " too large!");
        }
        this.thisOptional = null;
        this.active = false;
        this.changeStateTicks = 0;
        this.burnt = false;
    }

    public void writeData(CompoundNBT tag) {
        tag.func_74780_a("Energy", this.energy);
        if (this.inputItems.length + this.outputItems.length > 0) {
            ListNBT inv = new ListNBT();
            for (int slot = 0; slot < this.inputItems.length + this.outputItems.length; ++slot) {
                ItemStack stack = this.getStackInSlot(slot);
                if (stack.func_190926_b()) continue;
                CompoundNBT tag1 = stack.serializeNBT();
                tag1.func_74774_a("Slot", (byte)slot);
                inv.add((Object)tag1);
            }
            tag.func_218657_a("Inventory", (INBT)inv);
        }
        if (this.burnt) {
            tag.func_74757_a("Burnt", true);
        }
        if (!this.placerId.equals(Util.field_240973_b_)) {
            tag.func_186854_a("PlacerId", this.placerId);
            tag.func_74778_a("PlacerName", this.placerName);
        }
    }

    public void readData(CompoundNBT tag) {
        this.energy = tag.func_74769_h("Energy");
        if (this.inputItems.length + this.outputItems.length > 0) {
            Arrays.fill(this.inputItems, ItemStack.field_190927_a);
            Arrays.fill(this.outputItems, ItemStack.field_190927_a);
            ListNBT inv = tag.func_150295_c("Inventory", 10);
            for (int i = 0; i < inv.size(); ++i) {
                CompoundNBT tag1 = inv.func_150305_b(i);
                this.setStackInSlot(tag1.func_74771_c("Slot"), ItemStack.func_199557_a((CompoundNBT)tag1));
            }
        }
        this.burnt = tag.func_74767_n("Burnt");
        if (tag.func_186855_b("PlacerId")) {
            this.placerId = tag.func_186857_a("PlacerId");
            this.placerName = tag.func_74779_i("PlacerName");
        } else {
            this.placerId = Util.field_240973_b_;
            this.placerName = "";
        }
    }

    public void writeNetData(CompoundNBT tag) {
        if (this.burnt) {
            tag.func_74757_a("Burnt", true);
        }
    }

    public void readNetData(CompoundNBT tag) {
        this.burnt = tag.func_74767_n("Burnt");
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.readData(tag);
        this.initProperties();
        this.upgradesChanged();
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        this.writeData(tag);
        return tag;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.readNetData(tag);
        this.initProperties();
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        this.writeNetData(tag);
        return tag;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.readNetData(pkt.func_148857_g());
        this.initProperties();
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT tag = new CompoundNBT();
        this.writeNetData(tag);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, tag);
    }

    public void onLoad() {
        this.initProperties();
        if (this.field_145850_b != null && !this.field_145850_b.func_201670_d()) {
            this.upgradesChanged();
        }
        if (this.field_145850_b != null && this.field_145850_b.func_201670_d() && !this.tickClientSide()) {
            this.field_145850_b.field_175730_i.remove(this);
        }
        super.onLoad();
    }

    public boolean tickClientSide() {
        return false;
    }

    public LazyOptional<?> getThisOptional() {
        if (this.thisOptional == null) {
            this.thisOptional = LazyOptional.of(() -> this);
        }
        return this.thisOptional;
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.thisOptional != null) {
            this.thisOptional.invalidate();
            this.thisOptional = null;
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.inputItems.length + this.outputItems.length > 0) {
            return this.getThisOptional().cast();
        }
        return super.getCapability(cap, side);
    }

    protected void handleChanges() {
        if (this.changeStateTicks > 0) {
            --this.changeStateTicks;
        }
        if (this.changeStateTicks <= 0) {
            if (!this.isBurnt()) {
                if (this.field_145850_b != null && this.electricBlockInstance.canBeActive && this.func_195044_w().func_177230_c() instanceof ElectricBlock && (Boolean)this.func_195044_w().func_177229_b((Property)ElectricBlock.ACTIVE) != this.active && !this.field_145850_b.func_201670_d()) {
                    this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)ElectricBlock.ACTIVE, (Comparable)Boolean.valueOf(this.active)), 3);
                    this.func_70296_d();
                }
                this.active = false;
            }
            this.changeStateTicks = FTBICConfig.STATE_UPDATE_TICKS;
            if (this.changed) {
                this.setChangedNow();
            }
        }
    }

    public void func_73660_a() {
        this.handleChanges();
    }

    public void func_70296_d() {
        this.changed = true;
    }

    public void setChangedNow() {
        this.changed = false;
        this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
    }

    @Override
    public final double getEnergyCapacity() {
        return this.energyCapacity;
    }

    @Override
    public final double getEnergy() {
        return this.energy;
    }

    @Override
    public final void setEnergyRaw(double e) {
        this.energy = e;
    }

    public ActionResultType rightClick(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return ActionResultType.SUCCESS;
    }

    public void openMenu(ServerPlayerEntity player, final OpenMenuFactory openMenuFactory) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return ElectricBlockEntity.this.createDisplayName();
            }

            public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity player1) {
                return openMenuFactory.create(id, playerInv);
            }
        }, buf -> this.writeMenu(player, (PacketBuffer)buf));
    }

    public ITextComponent createDisplayName() {
        return new TranslationTextComponent(this.func_195044_w().func_177230_c().func_149739_a());
    }

    public void writeMenu(ServerPlayerEntity player, PacketBuffer buf) {
        buf.func_179255_a(this.field_174879_c);
    }

    @Override
    public boolean isEnergyHandlerInvalid() {
        return this.isBurnt() || this.func_145837_r();
    }

    @Override
    public final double getMaxInputEnergy() {
        return this.maxInputEnergy;
    }

    @Nullable
    public RecipeCache getRecipeCache() {
        return this.field_145850_b == null ? null : RecipeCache.get(this.field_145850_b);
    }

    public int getSlots() {
        return this.inputItems.length + this.outputItems.length;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
        if (slot >= this.inputItems.length) {
            return this.outputItems[slot - this.inputItems.length];
        }
        return this.inputItems[slot];
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
        if (slot >= this.inputItems.length) {
            ItemStack prev = this.outputItems[slot - this.inputItems.length];
            this.outputItems[slot - this.inputItems.length] = stack;
            this.inventoryChanged(slot, prev);
        } else {
            ItemStack prev = this.inputItems[slot];
            this.inputItems[slot] = stack;
            this.inventoryChanged(slot, prev);
        }
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (slot >= this.inputItems.length || stack.func_190926_b() || !this.isItemValid(slot, stack)) {
            return stack;
        }
        ItemStack existing = this.inputItems[slot];
        int limit = Math.min(this.getSlotLimit(slot), stack.func_77976_d());
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                ItemStack prev = this.inputItems[slot];
                this.inputItems[slot] = reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack;
                this.inventoryChanged(slot, prev);
            } else {
                ItemStack prev = existing.func_77946_l();
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
                this.inventoryChanged(slot, prev);
            }
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot < this.inputItems.length || amount <= 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack existing = this.outputItems[slot -= this.inputItems.length];
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.outputItems[slot] = ItemStack.field_190927_a;
                this.inventoryChanged(slot, existing);
                return existing;
            }
            return existing.func_77946_l();
        }
        if (!simulate) {
            this.outputItems[slot] = ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract));
            this.inventoryChanged(slot, existing);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public void inventoryChanged(int slot, @Nullable ItemStack prev) {
        this.func_70296_d();
    }

    public void energyChanged(int prev) {
        if (this.energy == 0.0 || prev == 0 || this.energy == this.energyCapacity) {
            this.func_70296_d();
        }
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return slot < this.inputItems.length;
    }

    public ItemStack addOutputInSlot(int slot, ItemStack stack) {
        boolean reachedLimit;
        if (this.outputItems[slot].func_190926_b()) {
            this.outputItems[slot] = stack;
            return ItemStack.field_190927_a;
        }
        ItemStack existing = this.outputItems[slot];
        int limit = stack.func_77976_d();
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (existing.func_190926_b()) {
            this.outputItems[slot] = reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack;
        } else {
            existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
        }
        this.inventoryChanged(slot, existing);
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    public ItemStack addOutput(ItemStack stack) {
        int i;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        for (i = 0; i < this.outputItems.length; ++i) {
            if (this.outputItems[i].func_77973_b() != stack.func_77973_b() || !(stack = this.addOutputInSlot(i, stack)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        for (i = 0; i < this.outputItems.length; ++i) {
            if (!this.outputItems[i].func_190926_b() || !(stack = this.addOutputInSlot(i, stack)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public Direction[] getEjectDirections() {
        if (this.electricBlockInstance.facingProperty != BlockStateProperties.field_208157_J) {
            return Direction.values();
        }
        Direction rot = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J);
        Direction[] values = new Direction[]{Direction.DOWN, rot.func_176735_f(), rot.func_176734_d(), rot.func_176746_e(), rot, Direction.UP};
        return values;
    }

    public void shiftInputs() {
        if (this.inputItems.length <= 1) {
            return;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.inputItems.length; ++i) {
            if (this.inputItems[i].func_190926_b()) continue;
            stacks.add(this.inputItems[i]);
            this.inputItems[i] = ItemStack.field_190927_a;
        }
        for (ItemStack stack : stacks) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)this, (ItemStack)stack, (boolean)false);
        }
    }

    public void ejectOutputItems() {
        if (!this.autoEject) {
            return;
        }
        Direction[] directions = null;
        block0: for (int i = 0; i < this.outputItems.length; ++i) {
            if (this.outputItems[i].func_190926_b()) continue;
            for (Direction direction : directions == null ? this.getEjectDirections() : directions) {
                IItemHandler itemHandler;
                TileEntity entity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
                IItemHandler iItemHandler = itemHandler = entity == null ? null : (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()).orElse(null);
                if (itemHandler == null) continue;
                this.outputItems[i] = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)this.outputItems[i].func_77946_l(), (boolean)false);
                if (!this.outputItems[i].func_190926_b()) continue;
                this.outputItems[i] = ItemStack.field_190927_a;
                continue block0;
            }
        }
    }

    public void onBroken(World level, BlockPos pos) {
        for (ItemStack stack : this.inputItems) {
            Block.func_180635_a((World)level, (BlockPos)pos, (ItemStack)stack);
        }
        for (ItemStack stack : this.outputItems) {
            Block.func_180635_a((World)level, (BlockPos)pos, (ItemStack)stack);
        }
    }

    public void initProperties() {
        this.energyCapacity = this.electricBlockInstance.energyCapacity;
        this.maxInputEnergy = this.electricBlockInstance.maxEnergyInput;
        this.autoEject = false;
    }

    public void upgradesChanged() {
    }

    public double getTotalPossibleEnergyCapacity() {
        return this.electricBlockInstance.energyCapacity;
    }

    public void addSyncData(SyncedData data) {
        data.addDouble(SyncedData.ENERGY, () -> this.energy);
        data.addDouble(SyncedData.ENERGY_CAPACITY, () -> this.energyCapacity);
    }

    @Override
    public final boolean canBurn() {
        return this.electricBlockInstance.canBurn;
    }

    @Override
    public final void setBurnt(boolean b) {
        if (this.burnt != b && !this.field_145850_b.func_201670_d() && this.canBurn()) {
            this.burnt = b;
            this.func_70296_d();
            this.syncBlock();
            ElectricBlockEntity.electricNetworkUpdated((IWorld)this.field_145850_b, this.field_174879_c);
            if (this.burnt) {
                this.field_145850_b.func_217379_c(1502, this.field_174879_c, 0);
                if (this.electricBlockInstance.canBeActive) {
                    this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)ElectricBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
                }
            }
        }
    }

    @Override
    public final boolean isBurnt() {
        return this.burnt;
    }

    public void stepOn(ServerPlayerEntity player) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnActiveParticles(World level, double x, double y, double z, BlockState state, Random r) {
    }

    public Direction getFacing(Direction def) {
        if (this.electricBlockInstance.facingProperty == null) {
            return def;
        }
        BlockState state = this.func_195044_w();
        if (state.func_177230_c() instanceof ElectricBlock) {
            return (Direction)state.func_177229_b((Property)this.electricBlockInstance.facingProperty);
        }
        return def;
    }

    public void onPlacedBy(@Nullable LivingEntity entity, ItemStack stack) {
        if (this.savePlacer()) {
            if (entity != null) {
                this.placerId = entity.func_110124_au();
                this.placerName = entity.func_195047_I_();
            } else if (!this.field_145850_b.func_201670_d()) {
                this.field_145850_b.func_217377_a(this.field_174879_c, false);
            }
        }
    }

    public boolean savePlacer() {
        return false;
    }

    public void syncBlock() {
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 11);
        this.func_70296_d();
    }

    public void neighborChanged(BlockPos pos1, Block block1) {
        if (!this.field_145850_b.func_180495_p(pos1).func_177230_c().func_235332_a_(block1)) {
            ElectricBlockEntity.electricNetworkUpdated((IWorld)this.field_145850_b, pos1);
        }
    }
}

