/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic;

import dev.ftb.mods.ftbic.util.CraftingMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.Nullable;

public class FTBICConfig {
    public static ITextComponent ENERGY_FORMAT = new StringTextComponent("\u26a1").func_240699_a_(TextFormatting.BOLD);
    public static ITextComponent HEAT_FORMAT = new StringTextComponent("\ud83d\udd25");
    public static double LV_TRANSFER_RATE = 32.0;
    public static double MV_TRANSFER_RATE = 128.0;
    public static double HV_TRANSFER_RATE = 512.0;
    public static double EV_TRANSFER_RATE = 2048.0;
    public static double IV_TRANSFER_RATE = 8192.0;
    public static double ITEM_TRANSFER_EFFICIENCY = 20.0;
    public static double ZAP_TO_FE_CONVERSION_RATE = 4.0;
    public static double SINGLE_USE_BATTERY_CAPACITY = 2400.0;
    public static double LV_BATTERY_CAPACITY = 4000.0;
    public static double MV_BATTERY_CAPACITY = 40000.0;
    public static double HV_BATTERY_CAPACITY = 400000.0;
    public static double EV_BATTERY_CAPACITY = 1.0E7;
    public static double CARBON_ARMOR_CAPACITY = 1000000.0;
    public static double QUANTUM_ARMOR_CAPACITY = 1.5E7;
    public static double MECHANICAL_ELYTRA_CAPACITY = 50000.0;
    public static double MECHANICAL_ELYTRA_RECHARGE = 1.0;
    public static double ARMOR_DAMAGE_ENERGY = 5000.0;
    public static double ARMOR_FLIGHT_ENERGY = 5.0;
    public static double ARMOR_FLIGHT_BOOST = 50.0;
    public static double ARMOR_FLIGHT_STOP = 15.0;
    public static double LV_BATTERY_BOX_CAPACITY = 40000.0;
    public static double MV_BATTERY_BOX_CAPACITY = 400000.0;
    public static double HV_BATTERY_BOX_CAPACITY = 4000000.0;
    public static double EV_BATTERY_BOX_CAPACITY = 4.0E7;
    public static int STATE_UPDATE_TICKS = 6;
    public static int IRON_FURNACE_ITEMS_PER_COAL = 12;
    public static int MAX_CABLE_LENGTH = 300;
    public static double NUKE_RADIUS = 36.0;
    public static boolean NUCLEAR_EXPLOSION_DAEMON_THREAD = false;
    public static double NUCLEAR_REACTOR_EXPLOSION_BASE_RADIUS = 10.0;
    public static double NUCLEAR_REACTOR_EXPLOSION_MULTIPLIER = 0.5;
    public static double NUCLEAR_REACTOR_EXPLOSION_LIMIT = 80.0;
    public static double BASIC_GENERATOR_CAPACITY = 4000.0;
    public static double BASIC_GENERATOR_OUTPUT = 10.0;
    public static int GEOTHERMAL_GENERATOR_TANK_SIZE = 8000;
    public static double GEOTHERMAL_GENERATOR_CAPACITY = 2400.0;
    public static double GEOTHERMAL_GENERATOR_OUTPUT = 20.0;
    public static double WIND_MILL_CAPACITY = 100.0;
    public static double WIND_MILL_MIN_OUTPUT = 0.3;
    public static double WIND_MILL_MAX_OUTPUT = 6.5;
    public static int WIND_MILL_MIN_Y = 64;
    public static int WIND_MILL_MAX_Y = 250;
    public static double WIND_MILL_RAIN_MODIFIER = 1.2;
    public static double WIND_MILL_THUNDER_MODIFIER = 1.5;
    public static double LV_SOLAR_PANEL_OUTPUT = 1.0;
    public static double MV_SOLAR_PANEL_OUTPUT = 8.0;
    public static double HV_SOLAR_PANEL_OUTPUT = 64.0;
    public static double EV_SOLAR_PANEL_OUTPUT = 512.0;
    public static double NUCLEAR_REACTOR_CAPACITY = 50000.0;
    public static double MACHINE_RECIPE_BASE_TICKS = 200.0;
    public static double POWERED_FURNACE_CAPACITY = 1200.0;
    public static double POWERED_FURNACE_USE = 3.0;
    public static double MACERATOR_CAPACITY = 1200.0;
    public static double MACERATOR_USE = 2.0;
    public static double CENTRIFUGE_CAPACITY = 1200.0;
    public static double CENTRIFUGE_USE = 2.0;
    public static double COMPRESSOR_CAPACITY = 1200.0;
    public static double COMPRESSOR_USE = 2.0;
    public static double REPROCESSOR_CAPACITY = 4000.0;
    public static double REPROCESSOR_USE = 8.0;
    public static double CANNING_MACHINE_CAPACITY = 1200.0;
    public static double CANNING_MACHINE_USE = 1.0;
    public static double ROLLER_CAPACITY = 1200.0;
    public static double ROLLER_USE = 3.0;
    public static double EXTRUDER_CAPACITY = 1200.0;
    public static double EXTRUDER_USE = 3.0;
    public static double ANTIMATTER_CONSTRUCTOR_CAPACITY = 1000000.0;
    public static double ANTIMATTER_CONSTRUCTOR_BOOST = 6.0;
    public static double ADVANCED_POWERED_FURNACE_CAPACITY = 10000.0;
    public static double ADVANCED_POWERED_FURNACE_USE = 16.0;
    public static double ADVANCED_MACERATOR_CAPACITY = 10000.0;
    public static double ADVANCED_MACERATOR_USE = 16.0;
    public static double ADVANCED_CENTRIFUGE_CAPACITY = 10000.0;
    public static double ADVANCED_CENTRIFUGE_USE = 16.0;
    public static double ADVANCED_COMPRESSOR_CAPACITY = 10000.0;
    public static double ADVANCED_COMPRESSOR_USE = 16.0;
    public static double TELEPORTER_CAPACITY = 1000000.0;
    public static double TELEPORTER_MIN_USE = 100.0;
    public static double TELEPORTER_MIN_DISTANCE = 16.0;
    public static double TELEPORTER_MAX_USE = 10000.0;
    public static double TELEPORTER_MAX_DISTANCE = 1200.0;
    public static double CHARGE_PAD_CAPACITY = 1000000.0;
    public static double POWERED_CRAFTING_TABLE_CAPACITY = 1200.0;
    public static double POWERED_CRAFTING_TABLE_USE = 1.0;
    public static double QUARRY_CAPACITY = 10000.0;
    public static double QUARRY_USE = 3.0;
    public static long QUARRY_MINE_TICKS = 40L;
    public static long QUARRY_MOVE_TICKS = 10L;
    public static double PUMP_CAPACITY = 10000.0;
    public static double PUMP_USE = 3.0;
    public static long PUMP_MINE_TICKS = 40L;
    public static long PUMP_MOVE_TICKS = 10L;
    public static int PUMP_TANK_CAPACITY = 128000;
    public static int UPGRADE_LIMIT_PER_SLOT = 4;
    public static double OVERCLOCKER_SPEED = 1.45;
    public static double OVERCLOCKER_ENERGY_USE = 1.6;
    public static double STORAGE_UPGRADE = 10000.0;
    public static int FLUID_CELL_CAPACITY = 1000;
    public static boolean ADD_ALL_FLUID_CELLS = false;
    public static boolean ADD_DUST_FROM_ORE_RECIPES = true;
    public static boolean ADD_DUST_FROM_MATERIAL_RECIPES = true;
    public static boolean ADD_GEM_FROM_ORE_RECIPES = true;
    public static boolean ADD_ROD_RECIPES = true;
    public static boolean ADD_PLATE_RECIPES = true;
    public static boolean ADD_GEAR_RECIPES = true;
    public static boolean ADD_CANNED_FOOD_RECIPES = true;
    public static double SCRAP_CHANCE = 0.125;
    public static final List<String> MOD_MATERIAL_PRIORITY = new ArrayList<String>(Arrays.asList("minecraft", "emendatusenigmatica", "thermal", "mekanism", "immersiveengineering"));
    public static final Map<String, CraftingMaterial> MATERIALS = new LinkedHashMap<String, CraftingMaterial>();

    public static void addMaterial(String m) {
        MATERIALS.put(m, new CraftingMaterial(m));
    }

    public static void removeMaterial(String m) {
        MATERIALS.remove(m);
    }

    private static int getOrder(@Nullable ResourceLocation id) {
        int i = id == null ? -1 : MOD_MATERIAL_PRIORITY.indexOf(id.func_110624_b());
        return i == -1 ? MOD_MATERIAL_PRIORITY.size() : i;
    }

    public static Item getItemFromTag(ITag<Item> tag) {
        List items = tag.func_230236_b_();
        if (items.isEmpty()) {
            return Items.field_190931_a;
        }
        if (items.size() == 1) {
            return (Item)items.get(0);
        }
        int order = Integer.MAX_VALUE;
        Item current = null;
        for (Item item : items) {
            int o = FTBICConfig.getOrder(item.getRegistryName());
            if (o == 0) {
                return item;
            }
            if (current != null && o >= order) continue;
            current = item;
            order = o;
        }
        return current;
    }

    public static void init() {
    }

    static {
        FTBICConfig.addMaterial("iron");
        FTBICConfig.addMaterial("gold");
        FTBICConfig.addMaterial("netherite");
        FTBICConfig.addMaterial("copper");
        FTBICConfig.addMaterial("aluminum");
        FTBICConfig.addMaterial("silver");
        FTBICConfig.addMaterial("lead");
        FTBICConfig.addMaterial("nickel");
        FTBICConfig.addMaterial("uranium");
        FTBICConfig.addMaterial("osmium");
        FTBICConfig.addMaterial("tin");
        FTBICConfig.addMaterial("zinc");
        FTBICConfig.addMaterial("cobalt");
        FTBICConfig.addMaterial("bronze");
        FTBICConfig.addMaterial("brass");
        FTBICConfig.addMaterial("constantan");
        FTBICConfig.addMaterial("electrum");
        FTBICConfig.addMaterial("steel");
        FTBICConfig.addMaterial("invar");
        FTBICConfig.addMaterial("signalum");
        FTBICConfig.addMaterial("lumium");
        FTBICConfig.addMaterial("enderium");
        FTBICConfig.addMaterial("iridium");
        FTBICConfig.addMaterial("cast_iron");
        FTBICConfig.addMaterial("tungsten");
        FTBICConfig.addMaterial("lithium");
        FTBICConfig.addMaterial("titanium");
        FTBICConfig.addMaterial("lapis");
        FTBICConfig.addMaterial("diamond");
        FTBICConfig.addMaterial("emerald");
        FTBICConfig.addMaterial("quartz");
        FTBICConfig.addMaterial("prismarine");
        FTBICConfig.addMaterial("certus_quartz");
        FTBICConfig.addMaterial("charged_certus_quartz");
        FTBICConfig.addMaterial("fluix");
        FTBICConfig.addMaterial("fluorite");
        FTBICConfig.addMaterial("bitumen");
        FTBICConfig.addMaterial("cinnabar");
        FTBICConfig.addMaterial("apatite");
        FTBICConfig.addMaterial("sulfur");
        FTBICConfig.addMaterial("potassium_nitrate");
        FTBICConfig.addMaterial("mana");
        FTBICConfig.addMaterial("dimensional");
        FTBICConfig.addMaterial("silicon");
        FTBICConfig.addMaterial("ruby");
        FTBICConfig.addMaterial("sapphire");
        FTBICConfig.addMaterial("peridot");
        FTBICConfig.addMaterial("redstone");
    }
}

