/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbic;

import dev.ftb.mods.ftbic.FTBICCommon;
import dev.ftb.mods.ftbic.FTBICConfig;
import dev.ftb.mods.ftbic.block.FTBICBlocks;
import dev.ftb.mods.ftbic.block.FTBICElectricBlocks;
import dev.ftb.mods.ftbic.block.entity.FTBICBlockEntities;
import dev.ftb.mods.ftbic.client.FTBICClient;
import dev.ftb.mods.ftbic.entity.FTBICEntities;
import dev.ftb.mods.ftbic.item.DummyEnergyArmorItem;
import dev.ftb.mods.ftbic.item.EnergyArmorItem;
import dev.ftb.mods.ftbic.item.FTBICItems;
import dev.ftb.mods.ftbic.net.FTBICNet;
import dev.ftb.mods.ftbic.recipe.FTBICRecipes;
import dev.ftb.mods.ftbic.screen.FTBICMenus;
import dev.ftb.mods.ftbic.sound.FTBICSounds;
import dev.ftb.mods.ftbic.util.FTBICUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Mod(value="ftbic")
@Mod.EventBusSubscriber(modid="ftbic")
public class FTBIC {
    public static final String MOD_ID = "ftbic";
    public static final String MOD_NAME = "FTB Industrial Contraptions";
    public static final Logger LOGGER = LogManager.getLogger((String)"FTB Industrial Contraptions");
    public static FTBICCommon PROXY;
    public static final ItemGroup TAB;

    public FTBIC() {
        PROXY = (FTBICCommon)DistExecutor.safeRunForDist(() -> FTBICClient::new, () -> FTBICCommon::new);
        FTBICBlocks.REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
        FTBICItems.REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
        FTBICBlockEntities.REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
        FTBICRecipes.REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
        FTBICMenus.REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
        FTBICEntities.REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
        FTBICSounds.REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
        FTBICElectricBlocks.init();
        FTBICUtils.init();
        FTBICNet.init();
        FTBICConfig.init();
        PROXY.init();
    }

    private static boolean isDummyArmor(LivingDamageEvent event, EquipmentSlotType slot, IArmorMaterial material) {
        Item item = event.getEntityLiving().func_184582_a(slot).func_77973_b();
        return item instanceof DummyEnergyArmorItem && ((DummyEnergyArmorItem)item).func_200880_d() == material;
    }

    @SubscribeEvent
    public static void playerDamage(LivingDamageEvent event) {
        EnergyArmorItem armorItem;
        ItemStack stack;
        if (!event.getSource().func_76357_e() && event.getEntityLiving() instanceof PlayerEntity && (stack = event.getEntityLiving().func_184582_a(EquipmentSlotType.CHEST)).func_77973_b() instanceof EnergyArmorItem && (armorItem = (EnergyArmorItem)stack.func_77973_b()).getEnergy(stack) > 0.0) {
            float protection = 0.35f;
            if (FTBIC.isDummyArmor(event, EquipmentSlotType.HEAD, armorItem.func_200880_d())) {
                protection += 0.25f;
            }
            if (FTBIC.isDummyArmor(event, EquipmentSlotType.LEGS, armorItem.func_200880_d())) {
                protection += 0.35f;
            }
            if (FTBIC.isDummyArmor(event, EquipmentSlotType.FEET, armorItem.func_200880_d())) {
                protection += 0.15f;
            }
            float amountReduced = event.getAmount() * Math.min(protection, 1.0f);
            double energy = FTBICConfig.ARMOR_DAMAGE_ENERGY * (double)amountReduced;
            ((EnergyArmorItem)stack.func_77973_b()).damageEnergyItem(stack, energy);
            event.setAmount(event.getAmount() - amountReduced);
        }
    }

    @Nullable
    private static Item missingItem(String name) {
        switch (name) {
            case "battery": {
                return FTBICItems.LV_BATTERY.get();
            }
            case "crystal_battery": {
                return FTBICItems.MV_BATTERY.get();
            }
            case "graphene_battery": {
                return FTBICItems.HV_BATTERY.get();
            }
            case "iridium_battery": {
                return FTBICItems.EV_BATTERY.get();
            }
            case "coolant_10k": {
                return FTBICItems.SMALL_COOLANT_CELL.get();
            }
            case "coolant_30k": {
                return FTBICItems.MEDIUM_COOLANT_CELL.get();
            }
            case "coolant_60k": {
                return FTBICItems.LARGE_COOLANT_CELL.get();
            }
        }
        return null;
    }

    @Nullable
    private static Block missingBlock(String name) {
        switch (name) {
            case "copper_cable": {
                return FTBICBlocks.LV_CABLE.get();
            }
            case "gold_cable": {
                return FTBICBlocks.MV_CABLE.get();
            }
            case "aluminum_cable": {
                return FTBICBlocks.HV_CABLE.get();
            }
            case "enderium_cable": {
                return FTBICBlocks.EV_CABLE.get();
            }
            case "glass_cable": {
                return FTBICBlocks.IV_CABLE.get();
            }
        }
        return null;
    }

    @SubscribeEvent
    public static void missingItems(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            if (!mapping.key.func_110624_b().equals(MOD_ID)) continue;
            Block block = FTBIC.missingBlock(mapping.key.func_110623_a());
            if (block != null) {
                mapping.remap((IForgeRegistryEntry)block.func_199767_j());
                continue;
            }
            Item item = FTBIC.missingItem(mapping.key.func_110623_a());
            if (item == null) continue;
            mapping.remap((IForgeRegistryEntry)item);
        }
    }

    @SubscribeEvent
    public static void missingBlocks(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            Block block;
            if (!mapping.key.func_110624_b().equals(MOD_ID) || (block = FTBIC.missingBlock(mapping.key.func_110623_a())) == null) continue;
            mapping.remap((IForgeRegistryEntry)block);
        }
    }

    static {
        TAB = new ItemGroup(MOD_ID){

            @OnlyIn(value=Dist.CLIENT)
            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)FTBICElectricBlocks.POWERED_FURNACE.item.get());
            }
        };
    }
}

