/*
 * Decompiled with CFR 0.152.
 */
package genetics.root;

import genetics.api.individual.IIndividual;
import genetics.api.root.IIndividualRoot;
import genetics.api.root.components.ComponentKey;
import genetics.api.root.components.ComponentKeys;
import genetics.api.root.translator.IBlockTranslator;
import genetics.api.root.translator.IIndividualTranslator;
import genetics.api.root.translator.IItemTranslator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class IndividualTranslator<I extends IIndividual>
implements IIndividualTranslator<I> {
    private final IIndividualRoot<I> root;
    private final Map<Item, IItemTranslator<I>> itemTranslators = new HashMap<Item, IItemTranslator<I>>();
    private final Map<Block, IBlockTranslator<I>> blockTranslators = new HashMap<Block, IBlockTranslator<I>>();

    public IndividualTranslator(IIndividualRoot<I> root) {
        this.root = root;
    }

    @Override
    public IIndividualRoot<I> getRoot() {
        return this.root;
    }

    @Override
    public IIndividualTranslator<I> registerTranslator(IBlockTranslator<I> translator, Block ... translatorKeys) {
        for (Block key : translatorKeys) {
            this.blockTranslators.put(key, translator);
        }
        return this;
    }

    @Override
    public IIndividualTranslator<I> registerTranslator(IItemTranslator<I> translator, Item ... translatorKeys) {
        for (Item key : translatorKeys) {
            this.itemTranslators.put(key, translator);
        }
        return this;
    }

    @Override
    public Optional<IItemTranslator<I>> getTranslator(Item translatorKey) {
        return Optional.ofNullable(this.itemTranslators.get(translatorKey));
    }

    @Override
    public Optional<IBlockTranslator<I>> getTranslator(Block translatorKey) {
        return Optional.ofNullable(this.blockTranslators.get(translatorKey));
    }

    @Override
    public Optional<I> translateMember(BlockState objectToTranslate) {
        Optional<IBlockTranslator<I>> optional = this.getTranslator(objectToTranslate.func_177230_c());
        return optional.map(iiBlockTranslator -> iiBlockTranslator.getIndividualFromObject(objectToTranslate));
    }

    @Override
    public Optional<I> translateMember(ItemStack objectToTranslate) {
        Optional<IItemTranslator<I>> optional = this.getTranslator(objectToTranslate.func_77973_b());
        return optional.map(iiItemTranslator -> iiItemTranslator.getIndividualFromObject(objectToTranslate));
    }

    @Override
    public ItemStack getGeneticEquivalent(BlockState objectToTranslate) {
        Optional<IBlockTranslator<I>> optional = this.getTranslator(objectToTranslate.func_177230_c());
        return optional.map(blockTranslator -> blockTranslator.getGeneticEquivalent(objectToTranslate)).orElse(ItemStack.field_190927_a);
    }

    @Override
    public ItemStack getGeneticEquivalent(ItemStack objectToTranslate) {
        Optional<IItemTranslator<I>> optional = this.getTranslator(objectToTranslate.func_77973_b());
        return optional.map(itemTranslator -> itemTranslator.getGeneticEquivalent(objectToTranslate)).orElse(ItemStack.field_190927_a);
    }

    @Override
    public ComponentKey<IIndividualTranslator> getKey() {
        return ComponentKeys.TRANSLATORS;
    }
}

