/*
 * Decompiled with CFR 0.152.
 */
package genetics.root;

import genetics.api.GeneticHelper;
import genetics.api.GeneticsAPI;
import genetics.api.alleles.IAlleleTemplateBuilder;
import genetics.api.individual.IIndividual;
import genetics.api.organism.IOrganism;
import genetics.api.root.EmptyRootDefinition;
import genetics.api.root.IIndividualRoot;
import genetics.api.root.IIndividualRootHelper;
import genetics.api.root.IRootDefinition;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.ItemStack;

public enum IndividualRootHelper implements IIndividualRootHelper
{
    INSTANCE;


    @Override
    public <R extends IIndividualRoot> IRootDefinition<R> getSpeciesRoot(ItemStack stack) {
        return this.getSpeciesRoot(stack, IIndividualRoot.class);
    }

    @Override
    public <R extends IIndividualRoot> IRootDefinition<R> getSpeciesRoot(ItemStack stack, Class<? extends R> rootClass) {
        if (stack.func_190926_b()) {
            return EmptyRootDefinition.empty();
        }
        Map<String, IRootDefinition> definitions = GeneticsAPI.apiInstance.getRoots();
        for (IRootDefinition definition : definitions.values()) {
            Object root;
            if (!definition.isPresent() || !(root = definition.get()).isMember(stack) || !rootClass.isInstance(root)) continue;
            return definition;
        }
        return EmptyRootDefinition.empty();
    }

    @Override
    public IRootDefinition getSpeciesRoot(Class<? extends IIndividual> individualClass) {
        return this.getSpeciesRoot(individualClass, IIndividualRoot.class);
    }

    @Override
    public <R extends IIndividualRoot> IRootDefinition<R> getSpeciesRoot(Class<? extends IIndividual> individualClass, Class<? extends R> rootClass) {
        Map<String, IRootDefinition> definitions = GeneticsAPI.apiInstance.getRoots();
        for (IRootDefinition rootDefinition : definitions.values()) {
            Object root;
            if (!rootDefinition.isPresent() || !(root = rootDefinition.get()).getMemberClass().isAssignableFrom(individualClass) || rootClass.isInstance(root)) continue;
            return rootDefinition;
        }
        return EmptyRootDefinition.empty();
    }

    @Override
    public <R extends IIndividualRoot> IRootDefinition<R> getSpeciesRoot(IIndividual individual) {
        return individual.getRoot().getDefinition();
    }

    @Override
    public <R extends IIndividualRoot> IRootDefinition<R> getSpeciesRoot(IIndividual individual, Class<? extends R> rootClass) {
        IIndividualRoot root = individual.getRoot();
        return rootClass.isInstance(root) ? root.getDefinition() : EmptyRootDefinition.empty();
    }

    @Override
    public boolean isIndividual(ItemStack stack) {
        return this.getSpeciesRoot(stack).isPresent();
    }

    @Override
    public Optional<IIndividual> getIndividual(ItemStack stack) {
        IOrganism organism = GeneticHelper.getOrganism(stack);
        return organism.getIndividual();
    }

    @Override
    public IAlleleTemplateBuilder createTemplate(String uid) {
        GeneticsAPI.apiInstance.getRoot(uid);
        return null;
    }
}

