/*
 * Decompiled with CFR 0.152.
 */
package genetics.individual;

import com.google.common.base.MoreObjects;
import genetics.ApiInstance;
import genetics.api.GeneticsAPI;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleRegistry;
import genetics.api.alleles.IAlleleSpecies;
import genetics.api.alleles.IAlleleValue;
import genetics.api.individual.IChromosome;
import genetics.api.individual.IChromosomeAllele;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IChromosomeValue;
import genetics.api.individual.IGenome;
import genetics.api.individual.IGenomeWrapper;
import genetics.api.individual.IKaryotype;
import genetics.api.root.IRootDefinition;
import genetics.individual.GeneticSaveHandler;
import genetics.utils.AlleleUtils;
import java.util.Arrays;
import net.minecraft.nbt.CompoundNBT;

public final class Genome
implements IGenome {
    private final IChromosome[] chromosomes;
    private final IKaryotype karyotype;

    public Genome(IKaryotype karyotype, CompoundNBT compound) {
        this.karyotype = karyotype;
        this.chromosomes = GeneticSaveHandler.INSTANCE.readTag(karyotype, compound);
    }

    public Genome(IKaryotype karyotype, IChromosome[] chromosomes) {
        this.karyotype = karyotype;
        this.checkChromosomes(chromosomes);
        this.chromosomes = chromosomes;
    }

    private void checkChromosomes(IChromosome[] chromosomes) {
        if (chromosomes.length != this.karyotype.getChromosomeTypes().length) {
            String message = String.format("Tried to create a genome for '%s' from an invalid chromosome template.\n%s", this.karyotype.getUID(), this.chromosomesToString(chromosomes));
            throw new IllegalArgumentException(message);
        }
        IAlleleRegistry registry = ApiInstance.INSTANCE.getAlleleRegistry();
        IChromosomeType[] chromosomeTypes = this.karyotype.getChromosomeTypes();
        for (int i = 0; i < chromosomeTypes.length; ++i) {
            IChromosomeType chromosomeType = chromosomeTypes[i];
            IChromosome chromosome = chromosomes[i];
            if (chromosome == null) {
                String message = String.format("Tried to create a genome for '%s' from an invalid chromosome template. Missing chromosome '%s'.\n%s", this.karyotype.getUID(), chromosomeType.getName(), this.chromosomesToString(chromosomes));
                throw new IllegalArgumentException(message);
            }
            IAllele primary = chromosome.getActiveAllele();
            if (primary == null) {
                String message = String.format("Tried to create a genome for '%s' from an invalid chromosome template. Missing active allele for '%s'.\n%s", this.karyotype.getUID(), chromosomeType.getName(), this.chromosomesToString(chromosomes));
                throw new IllegalArgumentException(message);
            }
            IAllele secondary = chromosome.getInactiveAllele();
            if (secondary == null) {
                String message = String.format("Tried to create a genome for '%s' from an invalid chromosome template. Missing inactive allele for '%s'.\n%s", this.karyotype.getUID(), chromosomeType.getName(), this.chromosomesToString(chromosomes));
                throw new IllegalArgumentException(message);
            }
            if (!registry.isValidAllele(primary, chromosomeType)) {
                String message = String.format("Tried to create a genome for '%s' from an invalid chromosome template. Incorrect type for active allele '%s'.\n%s.", this.karyotype.getUID(), chromosomeType.getName(), this.chromosomesToString(chromosomes));
                throw new IllegalArgumentException(message);
            }
            if (registry.isValidAllele(secondary, chromosomeType)) continue;
            String message = String.format("Tried to create a genome for '%s' from an invalid chromosome template. Incorrect type for inaktive allele '%s'.\n%s.", this.karyotype.getUID(), chromosomeType.getName(), this.chromosomesToString(chromosomes));
            throw new IllegalArgumentException(message);
        }
    }

    private String chromosomesToString(IChromosome[] chromosomes) {
        StringBuilder stringBuilder = new StringBuilder();
        IChromosomeType[] chromosomeTypes = this.karyotype.getChromosomeTypes();
        for (int i = 0; i < chromosomes.length; ++i) {
            IChromosomeType chromosomeType = chromosomeTypes[i];
            IChromosome chromosome = chromosomes[i];
            stringBuilder.append(chromosomeType.getName()).append(": ").append(chromosome).append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public IChromosome[] getChromosomes() {
        return Arrays.copyOf(this.chromosomes, this.chromosomes.length);
    }

    @Override
    public <A extends IAlleleSpecies> A getPrimary(Class<? extends A> alleleClass) {
        return (A)((IAlleleSpecies)this.getActiveAllele(this.karyotype.getSpeciesType(), alleleClass));
    }

    @Override
    public <A extends IAlleleSpecies> A getSecondary(Class<? extends A> alleleClass) {
        return (A)((IAlleleSpecies)this.getInactiveAllele(this.karyotype.getSpeciesType(), alleleClass));
    }

    @Override
    public IAllele getActiveAllele(IChromosomeType chromosomeType) {
        IChromosome chromosome = this.getChromosome(chromosomeType);
        return chromosome.getActiveAllele();
    }

    @Override
    public <V> IAlleleValue<V> getActiveAllele(IChromosomeValue<V> chromosomeType) {
        return this.getActiveAllele(chromosomeType, IAlleleValue.class);
    }

    @Override
    public <A extends IAllele> A getActiveAllele(IChromosomeAllele<A> chromosomeType) {
        IAllele allele;
        Class<A> alleleClass = chromosomeType.getAlleleClass();
        if (!alleleClass.isInstance(allele = this.getActiveAllele((IChromosomeType)chromosomeType))) {
            throw new IllegalArgumentException(String.format("The allele '%s' at the active position of the chromosome type '%s' is not an instance of the class '%s'.", allele, chromosomeType, alleleClass));
        }
        return (A)((IAllele)alleleClass.cast(allele));
    }

    @Override
    public <A extends IAllele> A getActiveAllele(IChromosomeAllele<A> chromosomeType, A fallback) {
        A allele;
        Class<A> alleleClass = chromosomeType.getAlleleClass();
        if (!alleleClass.isInstance(allele = this.getActiveAllele(chromosomeType))) {
            return fallback;
        }
        return (A)((IAllele)alleleClass.cast(allele));
    }

    @Override
    public <V> V getActiveValue(IChromosomeValue<V> chromosomeType) {
        IAlleleValue<V> allele = this.getActiveAllele(chromosomeType);
        V value = AlleleUtils.getAlleleValue(allele, chromosomeType.getValueClass());
        if (value == null) {
            throw new IllegalArgumentException(String.format("The allele '%s' at the active position of the chromosome type '%s' has no value.", allele, chromosomeType));
        }
        return value;
    }

    @Override
    public <V> V getActiveValue(IChromosomeValue<V> chromosomeType, V fallback) {
        IAlleleValue<V> allele = this.getActiveAllele(chromosomeType);
        return AlleleUtils.getAlleleValue(allele, chromosomeType.getValueClass(), fallback);
    }

    @Override
    public <A extends IAllele> A getActiveAllele(IChromosomeType chromosomeType, Class<? extends A> alleleClass) {
        IAllele allele = this.getActiveAllele(chromosomeType);
        if (!alleleClass.isInstance(allele)) {
            throw new IllegalArgumentException(String.format("The allele '%s' at the active position of the chromosome type '%s' is not an instance of the class '%s'.", allele, chromosomeType, alleleClass));
        }
        return (A)((IAllele)alleleClass.cast(allele));
    }

    @Override
    public <A extends IAllele> A getActiveAllele(IChromosomeType chromosomeType, Class<? extends A> alleleClass, A fallback) {
        IAllele allele = this.getActiveAllele(chromosomeType);
        if (!alleleClass.isInstance(allele)) {
            return fallback;
        }
        return (A)((IAllele)alleleClass.cast(allele));
    }

    @Override
    public IAllele getInactiveAllele(IChromosomeType chromosomeType) {
        IChromosome chromosome = this.getChromosome(chromosomeType);
        return chromosome.getInactiveAllele();
    }

    @Override
    public <A extends IAllele> A getInactiveAllele(IChromosomeType chromosomeType, Class<? extends A> alleleClass) {
        IAllele allele = this.getInactiveAllele(chromosomeType);
        if (!alleleClass.isInstance(allele)) {
            throw new IllegalArgumentException(String.format("The allele '%s' at the inactive position of the chromosome type '%s' is not an instance of the class '%s'.", allele, chromosomeType, alleleClass));
        }
        return (A)((IAllele)alleleClass.cast(allele));
    }

    @Override
    public <A extends IAllele> A getInactiveAllele(IChromosomeType chromosomeType, Class<? extends A> alleleClass, A fallback) {
        IAllele allele = this.getInactiveAllele(chromosomeType);
        if (!alleleClass.isInstance(allele)) {
            return fallback;
        }
        return (A)((IAllele)alleleClass.cast(allele));
    }

    @Override
    public <V> V getActiveValue(IChromosomeType chromosomeType, Class<? extends V> valueClass) {
        IAllele allele = this.getActiveAllele(chromosomeType);
        V value = AlleleUtils.getAlleleValue(allele, valueClass);
        if (value == null) {
            throw new IllegalArgumentException(String.format("The allele '%s' at the active position of the chromosome type '%s' has no value of the type '%s'.", allele, chromosomeType, valueClass));
        }
        return value;
    }

    @Override
    public <V> V getActiveValue(IChromosomeType chromosomeType, Class<? extends V> valueClass, V fallback) {
        IAllele allele = this.getActiveAllele(chromosomeType);
        return AlleleUtils.getAlleleValue(allele, valueClass, fallback);
    }

    @Override
    public <V> V getInactiveValue(IChromosomeType chromosomeType, Class<? extends V> valueClass) {
        IAllele allele = this.getInactiveAllele(chromosomeType);
        V value = AlleleUtils.getAlleleValue(allele, valueClass);
        if (value == null) {
            throw new IllegalArgumentException(String.format("The allele '%s' at the inactive position of the chromosome type '%s' has no value.", allele, chromosomeType));
        }
        return value;
    }

    @Override
    public <V> V getInactiveValue(IChromosomeType chromosomeType, Class<? extends V> valueClass, V fallback) {
        IAllele allele = this.getInactiveAllele(chromosomeType);
        return AlleleUtils.getAlleleValue(allele, valueClass, fallback);
    }

    @Override
    public <V> IAlleleValue<V> getInactiveAllele(IChromosomeValue<V> chromosomeType) {
        return this.getInactiveAllele(chromosomeType, IAlleleValue.class);
    }

    @Override
    public <A extends IAllele> A getInactiveAllele(IChromosomeAllele<A> chromosomeType) {
        IAllele allele;
        Class<A> alleleClass = chromosomeType.getAlleleClass();
        if (!alleleClass.isInstance(allele = this.getInactiveAllele((IChromosomeType)chromosomeType))) {
            throw new IllegalArgumentException(String.format("The allele '%s' at the active position of the chromosome type '%s' is not an instance of the class '%s'.", allele, chromosomeType, alleleClass));
        }
        return (A)((IAllele)alleleClass.cast(allele));
    }

    @Override
    public <A extends IAllele> A getInactiveAllele(IChromosomeAllele<A> chromosomeType, A fallback) {
        A allele;
        Class<A> alleleClass = chromosomeType.getAlleleClass();
        if (!alleleClass.isInstance(allele = this.getInactiveAllele(chromosomeType))) {
            return fallback;
        }
        return (A)((IAllele)alleleClass.cast(allele));
    }

    @Override
    public <V> V getInactiveValue(IChromosomeValue<V> chromosomeType) {
        IAlleleValue<V> allele = this.getInactiveAllele(chromosomeType);
        V value = AlleleUtils.getAlleleValue(allele, chromosomeType.getValueClass());
        if (value == null) {
            throw new IllegalArgumentException(String.format("The allele '%s' at the active position of the chromosome type '%s' has no value.", allele, chromosomeType));
        }
        return value;
    }

    @Override
    public <V> V getInactiveValue(IChromosomeValue<V> chromosomeType, V fallback) {
        IAlleleValue<V> allele = this.getInactiveAllele(chromosomeType);
        return AlleleUtils.getAlleleValue(allele, chromosomeType.getValueClass(), fallback);
    }

    @Override
    public IChromosome getChromosome(IChromosomeType chromosomeType) {
        return this.chromosomes[chromosomeType.getIndex()];
    }

    @Override
    public IAllele[][] getAlleles() {
        IAllele[][] alleles = new IAllele[this.chromosomes.length][2];
        for (IChromosome chromosome : this.chromosomes) {
            IAllele[] chromosomeAlleles = alleles[chromosome.getType().getIndex()];
            chromosomeAlleles[0] = chromosome.getActiveAllele();
            chromosomeAlleles[1] = chromosome.getInactiveAllele();
        }
        return alleles;
    }

    @Override
    public IAllele[] getActiveAlleles() {
        IAllele[] alleles = new IAllele[this.chromosomes.length];
        for (IChromosome chromosome : this.chromosomes) {
            alleles[chromosome.getType().getIndex()] = chromosome.getActiveAllele();
        }
        return alleles;
    }

    @Override
    public IAllele[] getInactiveAlleles() {
        IAllele[] alleles = new IAllele[this.chromosomes.length];
        for (IChromosome chromosome : this.chromosomes) {
            alleles[chromosome.getType().getIndex()] = chromosome.getInactiveAllele();
        }
        return alleles;
    }

    @Override
    public IKaryotype getKaryotype() {
        return this.karyotype;
    }

    @Override
    public <W extends IGenomeWrapper> W asWrapper(Class<? extends W> wrapperClass) {
        IRootDefinition definition = GeneticsAPI.apiInstance.getRoot(this.karyotype.getUID());
        if (!definition.isPresent()) {
            throw new IllegalStateException();
        }
        Object root = definition.get();
        IGenomeWrapper wrapper = root.createWrapper(this);
        if (!wrapperClass.isInstance(wrapper)) {
            throw new IllegalStateException();
        }
        return (W)((IGenomeWrapper)wrapperClass.cast(wrapper));
    }

    @Override
    public CompoundNBT writeToNBT(CompoundNBT compound) {
        return GeneticSaveHandler.INSTANCE.writeTag(this.chromosomes, this.karyotype, compound);
    }

    @Override
    public boolean isPureBred(IChromosomeType chromosomeType) {
        IChromosome chromosome = this.getChromosome(chromosomeType);
        return chromosome.isPureBred();
    }

    @Override
    public boolean isPureBred() {
        for (IChromosomeType chromosomeType : this.karyotype) {
            if (this.isPureBred(chromosomeType)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isGeneticEqual(IGenome other) {
        IChromosome[] otherChromosomes = other.getChromosomes();
        if (this.chromosomes.length != otherChromosomes.length) {
            return false;
        }
        for (int i = 0; i < this.chromosomes.length; ++i) {
            IChromosome chromosome = this.chromosomes[i];
            IChromosome otherChromosome = otherChromosomes[i];
            if (chromosome == null && otherChromosome == null) continue;
            if (chromosome == null || otherChromosome == null) {
                return false;
            }
            if (chromosome.isGeneticEqual(otherChromosome)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
        int i = 0;
        for (IChromosome chromosome : this.chromosomes) {
            toStringHelper.add(String.valueOf(i++), (Object)chromosome);
        }
        return toStringHelper.toString();
    }
}

