/*
 * Decompiled with CFR 0.152.
 */
package genetics.individual;

import genetics.ApiInstance;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleRegistry;
import genetics.api.individual.IChromosome;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IKaryotype;
import genetics.api.root.ITemplateContainer;
import genetics.utils.AlleleUtils;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;

@Immutable
public class Chromosome
implements IChromosome {
    private static final String ACTIVE_ALLELE_TAG = "UID0";
    private static final String INACTIVE_ALLELE_TAG = "UID1";
    private final IAllele active;
    private final IAllele inactive;
    private final IChromosomeType type;

    private Chromosome(IAllele allele, IChromosomeType type) {
        this.active = this.inactive = allele;
        this.type = type;
    }

    private Chromosome(IAllele active, IAllele inactive, IChromosomeType type) {
        this.active = active;
        this.inactive = inactive;
        this.type = type;
    }

    public static Chromosome create(@Nullable ResourceLocation primarySpeciesUid, @Nullable ResourceLocation secondarySpeciesUid, IChromosomeType type, CompoundNBT nbt) {
        Object firstAllele = AlleleUtils.getAlleleOrNull(nbt.func_74779_i(ACTIVE_ALLELE_TAG));
        Object secondAllele = AlleleUtils.getAlleleOrNull(nbt.func_74779_i(INACTIVE_ALLELE_TAG));
        return Chromosome.create(primarySpeciesUid, secondarySpeciesUid, type, firstAllele, secondAllele);
    }

    public static Chromosome create(@Nullable ResourceLocation primaryTemplateIdentifier, @Nullable ResourceLocation secondaryTemplateIdentifier, IChromosomeType type, @Nullable IAllele firstAllele, @Nullable IAllele secondAllele) {
        return Chromosome.create(Chromosome.getStringOrNull(primaryTemplateIdentifier), Chromosome.getStringOrNull(secondaryTemplateIdentifier), type, firstAllele, secondAllele);
    }

    public static Chromosome create(@Nullable String primaryTemplateIdentifier, @Nullable String secondaryTemplateIdentifier, IChromosomeType type, @Nullable IAllele firstAllele, @Nullable IAllele secondAllele) {
        firstAllele = Chromosome.validateAllele(primaryTemplateIdentifier, type, firstAllele);
        secondAllele = Chromosome.validateAllele(secondaryTemplateIdentifier, type, secondAllele);
        return new Chromosome(firstAllele, secondAllele, type);
    }

    @Nullable
    private static String getStringOrNull(@Nullable ResourceLocation location) {
        return location != null ? location.toString() : null;
    }

    private static IAllele validateAllele(@Nullable String templateIdentifier, IChromosomeType type, @Nullable IAllele allele) {
        IAlleleRegistry alleleRegistry = ApiInstance.INSTANCE.getAlleleRegistry();
        if (allele == null || !alleleRegistry.isValidAllele(allele, type)) {
            ITemplateContainer container = type.getRoot().getTemplates();
            IKaryotype karyotype = container.getKaryotype();
            IAllele[] template = null;
            if (templateIdentifier != null) {
                template = container.getTemplate(templateIdentifier);
            }
            if (template == null) {
                template = karyotype.getDefaultTemplate().alleles();
            }
            return template[type.getIndex()];
        }
        return allele;
    }

    public static Chromosome create(IAllele allele, IChromosomeType geneType) {
        return new Chromosome(allele, geneType);
    }

    static Optional<IAllele> getActiveAllele(CompoundNBT chromosomeNBT) {
        String alleleUid = chromosomeNBT.func_74779_i(ACTIVE_ALLELE_TAG);
        return AlleleUtils.getAllele(alleleUid);
    }

    static Optional<IAllele> getInactiveAllele(CompoundNBT chromosomeNBT) {
        String alleleUid = chromosomeNBT.func_74779_i(INACTIVE_ALLELE_TAG);
        return AlleleUtils.getAllele(alleleUid);
    }

    @Override
    public IChromosomeType getType() {
        return this.type;
    }

    @Override
    public IAllele getActiveAllele() {
        return this.active;
    }

    @Override
    public IAllele getInactiveAllele() {
        return this.inactive;
    }

    @Override
    public boolean isPureBred() {
        return this.active.equals(this.inactive);
    }

    @Override
    public boolean isGeneticEqual(IChromosome other) {
        if (!this.active.equals(other.getActiveAllele())) {
            return false;
        }
        return this.inactive.equals(other.getInactiveAllele());
    }

    @Override
    public CompoundNBT writeToNBT(CompoundNBT nbttagcompound) {
        nbttagcompound.func_74778_a(ACTIVE_ALLELE_TAG, this.active.getRegistryName().toString());
        nbttagcompound.func_74778_a(INACTIVE_ALLELE_TAG, this.inactive.getRegistryName().toString());
        return nbttagcompound;
    }

    @Override
    public IChromosome inheritChromosome(Random rand, IChromosome other) {
        IAllele firstChoice = rand.nextBoolean() ? this.getActiveAllele() : this.getInactiveAllele();
        IAllele secondChoice = rand.nextBoolean() ? other.getActiveAllele() : other.getInactiveAllele();
        if (rand.nextBoolean()) {
            return Chromosome.create(firstChoice, secondChoice, this.type);
        }
        return Chromosome.create(secondChoice, firstChoice, this.type);
    }

    public static Chromosome create(IAllele firstAllele, IAllele secondAllele, IChromosomeType geneType) {
        firstAllele = Chromosome.getActiveAllele(firstAllele, secondAllele);
        secondAllele = Chromosome.getInactiveAllele(firstAllele, secondAllele);
        return new Chromosome(firstAllele, secondAllele, geneType);
    }

    private static IAllele getActiveAllele(IAllele firstAllele, IAllele secondAllele) {
        if (firstAllele.isDominant()) {
            return firstAllele;
        }
        if (secondAllele.isDominant()) {
            return secondAllele;
        }
        return firstAllele;
    }

    private static IAllele getInactiveAllele(IAllele firstAllele, IAllele secondAllele) {
        if (!secondAllele.isDominant()) {
            return secondAllele;
        }
        if (!firstAllele.isDominant()) {
            return firstAllele;
        }
        return secondAllele;
    }

    public String toString() {
        return "{" + this.active + ", " + this.inactive + "}";
    }
}

