/*
 * Decompiled with CFR 0.152.
 */
package genetics.commands;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import genetics.api.GeneticsAPI;
import genetics.api.individual.IChromosome;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IGenome;
import genetics.api.individual.IIndividual;
import genetics.commands.CommandHelpers;
import genetics.commands.PermLevel;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;

public class CommandListAlleles {
    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"listAlleles").requires((Predicate)PermLevel.ADMIN)).executes(CommandListAlleles::execute);
    }

    public static int execute(CommandContext<CommandSource> context) throws CommandException, CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        ItemStack stack = player.func_184614_ca();
        Optional<IIndividual> individual = GeneticsAPI.apiInstance.getRootHelper().getIndividual(stack);
        if (!individual.isPresent()) {
            return 0;
        }
        IGenome genome = individual.get().getGenome();
        for (IChromosome chromosome : genome.getChromosomes()) {
            IChromosomeType type = chromosome.getType();
            CommandHelpers.sendChatMessage((CommandSource)context.getSource(), type.getName() + ": " + genome.getActiveAllele(type).getDisplayName().getString() + " " + genome.getInactiveAllele(type).getDisplayName().getString());
        }
        GeneticsAPI.apiInstance.getAlleleRegistry().getRegisteredAlleles().forEach(a -> System.out.println(a.getRegistryName() + ": " + a.getDisplayName().getString()));
        return 1;
    }
}

