/*
 * Decompiled with CFR 0.152.
 */
package genetics.api.alleles;

import genetics.api.GeneticsAPI;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleProvider;
import genetics.api.alleles.IAlleleTemplate;
import genetics.api.alleles.IAlleleValue;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IKaryotype;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;

public interface IAlleleTemplateBuilder {
    public IAlleleTemplateBuilder set(IChromosomeType var1, IAllele var2);

    default public IAlleleTemplateBuilder set(IChromosomeType chromosomeType, IAlleleProvider provider) {
        return this.set(chromosomeType, provider.getAllele());
    }

    default public IAlleleTemplateBuilder set(IChromosomeType chromosomeType, Object value) {
        Optional<IAlleleValue<Object>> optionalAllele = GeneticsAPI.apiInstance.getAlleleHelper().getAllele(chromosomeType, value);
        if (!optionalAllele.isPresent()) {
            throw new IllegalArgumentException("Attempted to set the allele at the position '" + chromosomeType + "' to the allele with the value '" + value + "'.But no allele was registered with that value for that chromosome type.");
        }
        return this.set(chromosomeType, optionalAllele.get());
    }

    public IAlleleTemplateBuilder set(IChromosomeType var1, ResourceLocation var2);

    default public IAlleleTemplateBuilder set(IChromosomeType chromosomeType, String registryName) {
        return this.set(chromosomeType, new ResourceLocation(registryName));
    }

    public IKaryotype getKaryotype();

    public int size();

    public IAlleleTemplate build();
}

