/*
 * Decompiled with CFR 0.152.
 */
package genetics.api.alleles;

import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleData;
import genetics.api.alleles.IAlleleHandler;
import genetics.api.alleles.IAlleleValue;
import genetics.api.individual.IChromosomeType;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;

public interface IAlleleRegistry {
    public <V> IAlleleValue<V> registerAllele(IAlleleData<V> var1, IChromosomeType ... var2);

    public <V> IAlleleValue<V>[] registerAlleles(IAlleleData<V>[] var1, IChromosomeType ... var2);

    public <V> IAlleleValue<V> registerAllele(String var1, String var2, V var3, boolean var4, IChromosomeType ... var5);

    public <A extends IAllele> A registerAllele(A var1, IChromosomeType ... var2);

    default public IAlleleRegistry addValidAlleleTypes(String registryName, IChromosomeType ... types) {
        return this.addValidAlleleTypes(new ResourceLocation(registryName), types);
    }

    public IAlleleRegistry addValidAlleleTypes(ResourceLocation var1, IChromosomeType ... var2);

    public IAlleleRegistry addValidAlleleTypes(IAllele var1, IChromosomeType ... var2);

    public IAllele getDefaultAllele();

    public ResourceLocation getDefaultKey();

    public Optional<IAllele> getAllele(ResourceLocation var1);

    public Collection<IChromosomeType> getChromosomeTypes(IAllele var1);

    public Collection<IAllele> getRegisteredAlleles(IChromosomeType var1);

    public Collection<IAllele> getRegisteredAlleles();

    public Collection<ResourceLocation> getRegisteredNames();

    public boolean isValidAllele(IAllele var1, IChromosomeType var2);

    public void registerHandler(IAlleleHandler var1);

    public Collection<IAlleleHandler> getHandlers();

    public void blacklistAllele(ResourceLocation var1);

    public Collection<ResourceLocation> getAlleleBlacklist();

    public boolean isBlacklisted(ResourceLocation var1);
}

