/*
 * Decompiled with CFR 0.152.
 */
package genetics.api.alleles;

import com.google.common.base.MoreObjects;
import genetics.api.alleles.Allele;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleValue;
import java.util.Objects;

public class AlleleValue<V>
extends Allele
implements IAlleleValue<V> {
    protected final V value;

    public AlleleValue(String unlocalizedName, boolean dominant, V value) {
        super(unlocalizedName, dominant);
        this.value = value;
    }

    @Override
    public final V getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return this.getRegistryName() != null ? this.getRegistryName().hashCode() : Objects.hash(this.value, this.dominant);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IAlleleValue)) {
            return false;
        }
        IAlleleValue otherAllele = (IAlleleValue)obj;
        return this.getRegistryName() != null ? this.getRegistryName().equals((Object)((IAllele)obj).getRegistryName()) : Objects.equals(this.value, otherAllele.getValue()) && this.dominant == otherAllele.isDominant();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getRegistryName()).add("value", this.value).add("dominant", this.dominant).add("unloc", (Object)this.getLocalisationKey()).toString();
    }
}

