/*
 * Decompiled with CFR 0.152.
 */
package forestry.worktable.recipes;

import forestry.api.core.INbtWritable;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.utils.WorldUtils;
import forestry.worktable.recipes.MemorizedRecipe;
import java.io.IOException;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RecipeMemory
implements INbtWritable,
IStreamable {
    private static final int capacity = 9;
    private final LinkedList<MemorizedRecipe> memorizedRecipes = new LinkedList();
    private long lastUpdate;

    public RecipeMemory() {
    }

    public RecipeMemory(CompoundNBT nbt) {
        if (!nbt.func_74764_b("RecipeMemory")) {
            return;
        }
        ListNBT nbttaglist = nbt.func_150295_c("RecipeMemory", 10);
        for (int j = 0; j < nbttaglist.size(); ++j) {
            CompoundNBT recipeNbt = nbttaglist.func_150305_b(j);
            MemorizedRecipe recipe = new MemorizedRecipe(recipeNbt);
            if (!recipe.hasSelectedRecipe()) continue;
            this.memorizedRecipes.add(recipe);
        }
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public void memorizeRecipe(long worldTime, MemorizedRecipe recipe, World world) {
        MemorizedRecipe memory;
        ICraftingRecipe selectedRecipe = recipe.getSelectedRecipe(world);
        if (selectedRecipe == null) {
            return;
        }
        this.lastUpdate = worldTime;
        recipe.updateLastUse(this.lastUpdate);
        if (recipe.hasRecipeConflict()) {
            recipe.removeRecipeConflicts(world);
        }
        if ((memory = this.getExistingMemorizedRecipe(selectedRecipe, world)) != null) {
            this.updateExistingRecipe(memory, recipe);
            return;
        }
        if (this.memorizedRecipes.size() < 9) {
            this.memorizedRecipes.add(recipe);
        } else {
            MemorizedRecipe oldest = this.getOldestUnlockedRecipe();
            if (oldest != null) {
                this.memorizedRecipes.remove(oldest);
                this.memorizedRecipes.add(recipe);
            }
        }
    }

    private void updateExistingRecipe(MemorizedRecipe existingRecipe, MemorizedRecipe updatedRecipe) {
        if (existingRecipe.isLocked() != updatedRecipe.isLocked()) {
            updatedRecipe.toggleLock();
        }
        int index = this.memorizedRecipes.indexOf(existingRecipe);
        this.memorizedRecipes.set(index, updatedRecipe);
    }

    @Nullable
    private MemorizedRecipe getOldestUnlockedRecipe() {
        MemorizedRecipe oldest = null;
        for (MemorizedRecipe existing : this.memorizedRecipes) {
            if (oldest != null && oldest.getLastUsed() < existing.getLastUsed() || existing.isLocked()) continue;
            oldest = existing;
        }
        return oldest;
    }

    @Nullable
    public MemorizedRecipe getRecipe(int recipeIndex) {
        if (recipeIndex < 0 || recipeIndex >= this.memorizedRecipes.size()) {
            return null;
        }
        return this.memorizedRecipes.get(recipeIndex);
    }

    public ItemStack getRecipeDisplayOutput(int recipeIndex) {
        MemorizedRecipe recipe = this.getRecipe(recipeIndex);
        if (recipe == null) {
            return ItemStack.field_190927_a;
        }
        ClientWorld world = WorldUtils.client();
        return recipe.getOutputIcon((World)world);
    }

    public boolean isLocked(int recipeIndex) {
        MemorizedRecipe recipe = this.getRecipe(recipeIndex);
        return recipe != null && recipe.isLocked();
    }

    public void toggleLock(long worldTime, int recipeIndex) {
        this.lastUpdate = worldTime;
        if (this.memorizedRecipes.size() > recipeIndex) {
            this.memorizedRecipes.get(recipeIndex).toggleLock();
        }
    }

    @Nullable
    private MemorizedRecipe getExistingMemorizedRecipe(@Nullable ICraftingRecipe recipe, World world) {
        if (recipe != null) {
            for (MemorizedRecipe memorizedRecipe : this.memorizedRecipes) {
                if (!memorizedRecipe.hasRecipe(recipe, world)) continue;
                return memorizedRecipe;
            }
        }
        return null;
    }

    @Override
    public CompoundNBT write(CompoundNBT compoundNBT) {
        ListNBT listNBT = new ListNBT();
        for (MemorizedRecipe recipe : this.memorizedRecipes) {
            if (recipe == null || !recipe.hasSelectedRecipe()) continue;
            CompoundNBT recipeNbt = new CompoundNBT();
            recipe.write(recipeNbt);
            listNBT.add((Object)recipeNbt);
        }
        compoundNBT.func_218657_a("RecipeMemory", (INBT)listNBT);
        return compoundNBT;
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        data.writeStreamables(this.memorizedRecipes);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
        data.readStreamables(this.memorizedRecipes, MemorizedRecipe::new);
    }
}

