/*
 * Decompiled with CFR 0.152.
 */
package forestry.worktable.gui;

import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.buttons.GuiBetterButton;
import forestry.core.gui.buttons.StandardButtonTextureSets;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.SoundUtil;
import forestry.worktable.gui.ContainerWorktable;
import forestry.worktable.gui.widgets.ClearWorktable;
import forestry.worktable.gui.widgets.MemorizedRecipeSlot;
import forestry.worktable.recipes.RecipeMemory;
import forestry.worktable.tiles.TileWorktable;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiWorktable
extends GuiForestryTitled<ContainerWorktable> {
    private static final int SPACING = 18;
    private final TileWorktable tile;
    private boolean hasRecipeConflict = false;

    public GuiWorktable(ContainerWorktable container, PlayerInventory inv, ITextComponent title) {
        super("textures/gui/worktable2.png", container, inv, title);
        this.tile = (TileWorktable)container.getTile();
        this.field_147000_g = 218;
        RecipeMemory recipeMemory = this.tile.getMemory();
        int slot = 0;
        for (int y = 0; y < 3; ++y) {
            int yPos = 20 + y * 18;
            for (int x = 0; x < 3; ++x) {
                int xPos = 110 + x * 18;
                MemorizedRecipeSlot memorizedRecipeSlot = new MemorizedRecipeSlot(this.widgetManager, xPos, yPos, recipeMemory, slot++);
                this.widgetManager.add(memorizedRecipeSlot);
            }
        }
        this.widgetManager.add(new ClearWorktable(this.widgetManager, 66, 19));
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.hasRecipeConflict != this.tile.hasRecipeConflict()) {
            this.hasRecipeConflict = this.tile.hasRecipeConflict();
            if (this.hasRecipeConflict) {
                this.addButtons();
            } else {
                this.field_230710_m_.clear();
                this.field_230705_e_.clear();
            }
        }
    }

    private void addButtons() {
        this.func_230480_a_((Widget)new GuiBetterButton(this.field_147003_i + 76, this.field_147009_r + 56, StandardButtonTextureSets.LEFT_BUTTON_SMALL, b -> {
            NetworkUtil.sendToServer(new PacketGuiSelectRequest(100, 0));
            SoundUtil.playButtonClick();
        }));
        this.func_230480_a_((Widget)new GuiBetterButton(this.field_147003_i + 85, this.field_147009_r + 56, StandardButtonTextureSets.RIGHT_BUTTON_SMALL, b -> {
            NetworkUtil.sendToServer(new PacketGuiSelectRequest(101, 0));
            SoundUtil.playButtonClick();
        }));
    }

    @Override
    protected void addLedgers() {
        this.addErrorLedger(this.tile);
        this.addHintLedger("worktable");
    }
}

