/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage.models;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.core.models.AbstractBakedModel;
import forestry.core.models.TRSRBakedModel;
import forestry.core.utils.ResourceUtil;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.common.model.TransformationHelper;

public class CrateBakedModel
extends AbstractBakedModel {
    private static final float CONTENT_RENDER_OFFSET_X = 0.0625f;
    private static final float CONTENT_RENDER_OFFSET_Z = 0.001953125f;
    private static final float CONTENT_RENDER_BLOCK_Z_SCALE = 0.064453125f;
    private ContentModel contentModel;

    CrateBakedModel(List<BakedQuad> quads) {
        this.contentModel = new ContentModel(quads);
    }

    CrateBakedModel(List<BakedQuad> quads, ItemStack content) {
        this.contentModel = new RawContentModel(quads, content);
    }

    @Override
    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        if (side != null) {
            return ImmutableList.of();
        }
        if (this.contentModel.hasBakedModel()) {
            this.contentModel = this.contentModel.bake();
        }
        return this.contentModel.getQuads();
    }

    private static class RawContentModel
    extends ContentModel {
        private final ItemStack content;

        private RawContentModel(List<BakedQuad> quads, ItemStack content) {
            super(quads);
            this.content = content;
        }

        @Override
        public ContentModel bake() {
            IBakedModel bakedModel = ResourceUtil.getModel(this.content);
            if (bakedModel != null) {
                IBakedModel guiModel = bakedModel.handlePerspective(ItemCameraTransforms.TransformType.GUI, new MatrixStack());
                List general = guiModel.func_200117_a(null, null, new Random(0L));
                if (!general.isEmpty()) {
                    TransformationMatrix frontTransform = new TransformationMatrix(new Vector3f(-0.0625f, 0.0f, 0.001953125f), null, new Vector3f(0.5f, 0.5f, 1.0f), null);
                    TRSRBakedModel frontModel = new TRSRBakedModel(guiModel, frontTransform);
                    this.quads.addAll(frontModel.func_200117_a(null, null, new Random(0L)));
                    TransformationMatrix backTransform = new TransformationMatrix(new Vector3f(-0.0625f, 0.0f, -0.001953125f), null, new Vector3f(0.5f, 0.5f, 1.0f), TransformationHelper.quatFromXYZ((Vector3f)new Vector3f(0.0f, (float)Math.PI, 0.0f), (boolean)false));
                    TRSRBakedModel backModel = new TRSRBakedModel(guiModel, backTransform);
                    this.quads.addAll(backModel.func_200117_a(null, null, new Random(0L)));
                } else {
                    TransformationMatrix frontTransform = new TransformationMatrix(new Vector3f(-0.0625f, 0.0f, 0.0f), null, new Vector3f(0.5f, 0.5f, 0.064453125f), null);
                    TRSRBakedModel frontModel = new TRSRBakedModel(guiModel, frontTransform);
                    for (Direction direction : Direction.field_199792_n) {
                        this.quads.addAll(frontModel.func_200117_a(null, direction, new Random(0L)));
                    }
                }
            }
            return new ContentModel(this.quads);
        }

        @Override
        public boolean hasBakedModel() {
            return true;
        }
    }

    private static class ContentModel {
        final List<BakedQuad> quads;

        private ContentModel(List<BakedQuad> quads) {
            this.quads = quads;
        }

        public List<BakedQuad> getQuads() {
            return this.quads;
        }

        public ContentModel bake() {
            return this;
        }

        public boolean hasBakedModel() {
            return false;
        }
    }
}

