/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import forestry.api.storage.EnumBackpackType;
import forestry.core.models.AbstractItemModel;
import forestry.storage.BackpackMode;
import forestry.storage.items.ItemBackpack;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public class BackpackItemModel
extends AbstractItemModel {
    private static ImmutableMap<EnumBackpackType, ImmutableMap<BackpackMode, IBakedModel>> cachedBakedModels = ImmutableMap.of();

    @Override
    protected IBakedModel getOverride(IBakedModel model, ItemStack stack) {
        BackpackMode mode = ItemBackpack.getMode(stack);
        EnumBackpackType type = ItemBackpack.getType(stack);
        return (IBakedModel)((ImmutableMap)cachedBakedModels.getOrDefault((Object)type, (Object)ImmutableMap.of())).getOrDefault((Object)mode, (Object)model);
    }

    public static class Loader
    implements IModelLoader<Geometry> {
        public static final ResourceLocation LOCATION = new ResourceLocation("forestry", "backpacks");

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public Geometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            return new Geometry();
        }
    }

    private static class Geometry
    implements IModelGeometry<Geometry> {
        private Geometry() {
        }

        public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
            if (cachedBakedModels.isEmpty()) {
                ImmutableMap.Builder modelBuilder = new ImmutableMap.Builder();
                for (EnumBackpackType backpackType : EnumBackpackType.values()) {
                    ImmutableMap.Builder modeModels = new ImmutableMap.Builder();
                    for (BackpackMode mode : BackpackMode.values()) {
                        modeModels.put((Object)mode, (Object)bakery.getBakedModel((ResourceLocation)backpackType.getLocation(mode), modelTransform, spriteGetter));
                    }
                    modelBuilder.put((Object)backpackType, (Object)modeModels.build());
                }
                cachedBakedModels = modelBuilder.build();
            }
            return new BackpackItemModel();
        }

        public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return ImmutableList.of();
        }
    }
}

