/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage.items;

import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import forestry.core.ItemGroupForestry;
import forestry.storage.gui.ContainerNaturalistBackpack;
import forestry.storage.inventory.ItemInventoryBackpackPaged;
import forestry.storage.items.ItemBackpack;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ItemBackpackNaturalist
extends ItemBackpack {
    private final String rootUid;

    public ItemBackpackNaturalist(String rootUid, IBackpackDefinition definition) {
        this(rootUid, definition, ItemGroupForestry.tabForestry);
    }

    public ItemBackpackNaturalist(String rootUid, IBackpackDefinition definition, ItemGroup tab) {
        super(definition, EnumBackpackType.NATURALIST, tab);
        this.rootUid = rootUid;
    }

    @Override
    public Container getContainer(int windowId, PlayerEntity player, ItemStack heldItem) {
        ItemInventoryBackpackPaged inventory = new ItemInventoryBackpackPaged(player, 125, heldItem, this);
        return new ContainerNaturalistBackpack(windowId, player.field_71071_by, inventory, 0);
    }

    public static class ContainerProvider
    implements INamedContainerProvider {
        private ItemStack heldItem;

        public ContainerProvider(ItemStack heldItem) {
            this.heldItem = heldItem;
        }

        public ITextComponent func_145748_c_() {
            return new StringTextComponent("ITEM_GUI_TITLE");
        }

        @Nullable
        public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
            Item item = this.heldItem.func_77973_b();
            if (!(item instanceof ItemBackpackNaturalist)) {
                return null;
            }
            ItemBackpackNaturalist backpack = (ItemBackpackNaturalist)item;
            return backpack.getContainer(windowId, playerEntity, this.heldItem);
        }
    }
}

