/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage.items;

import com.google.common.base.Preconditions;
import forestry.api.core.ItemGroups;
import forestry.api.storage.BackpackStowEvent;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import forestry.core.config.Config;
import forestry.core.inventory.ItemHandlerInventoryManipulator;
import forestry.core.inventory.ItemInventory;
import forestry.core.inventory.StandardStackFilters;
import forestry.core.items.ItemWithGui;
import forestry.core.items.definitions.IColoredItem;
import forestry.core.network.PacketBufferForestry;
import forestry.core.tiles.TileUtil;
import forestry.storage.BackpackMode;
import forestry.storage.gui.ContainerBackpack;
import forestry.storage.inventory.ItemInventoryBackpack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;

public class ItemBackpack
extends ItemWithGui
implements IColoredItem {
    private final IBackpackDefinition definition;
    private final EnumBackpackType type;

    public ItemBackpack(IBackpackDefinition definition, EnumBackpackType type) {
        this(definition, type, ItemGroups.tabStorage);
    }

    public ItemBackpack(IBackpackDefinition definition, EnumBackpackType type, ItemGroup tab) {
        super(new Item.Properties().func_200916_a(tab));
        Preconditions.checkNotNull((Object)definition, (Object)"Backpack must have a backpack definition.");
        Preconditions.checkNotNull((Object)((Object)type), (Object)"Backpack must have a backpack type.");
        this.definition = definition;
        this.type = type;
    }

    public IBackpackDefinition getDefinition() {
        return this.definition;
    }

    @Override
    protected void writeContainerData(ServerPlayerEntity player, ItemStack stack, PacketBufferForestry buffer) {
        buffer.writeEnum(this.type == EnumBackpackType.WOVEN ? ContainerBackpack.Size.T2 : ContainerBackpack.Size.DEFAULT, ContainerBackpack.Size.values());
        buffer.func_150788_a(stack);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!playerIn.func_225608_bj_()) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        ItemBackpack.switchMode(heldItem);
        return ActionResult.func_226248_a_((Object)heldItem);
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        if (ItemBackpack.getInventoryHit(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l()) != null) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player.func_225608_bj_()) {
            ItemStack heldItem = player.func_184586_b(context.func_221531_n());
            return this.evaluateTileHit(heldItem, player, context.func_195991_k(), context.func_195995_a(), context.func_196000_l()) ? ActionResultType.PASS : ActionResultType.FAIL;
        }
        return super.onItemUseFirst(stack, context);
    }

    public static void tryStowing(PlayerEntity player, ItemStack backpackStack, ItemStack stack) {
        if (ItemBackpack.getMode(backpackStack) == BackpackMode.LOCKED) {
            return;
        }
        ItemBackpack backpack = (ItemBackpack)backpackStack.func_77973_b();
        ItemInventoryBackpack inventory = new ItemInventoryBackpack(player, backpack.getBackpackSize(), backpackStack);
        if (MinecraftForge.EVENT_BUS.post((Event)new BackpackStowEvent(player, backpack.getDefinition(), inventory, stack))) {
            return;
        }
        if (stack.func_190926_b()) {
            return;
        }
        IItemHandler itemHandler = inventory.getItemHandler();
        ItemHandlerInventoryManipulator manipulator = new ItemHandlerInventoryManipulator(itemHandler);
        ItemStack remainder = manipulator.addStack(stack);
        stack.func_190920_e(remainder == null ? 0 : remainder.func_190916_E());
    }

    private static void switchMode(ItemStack itemstack) {
        BackpackMode mode = ItemBackpack.getMode(itemstack);
        int nextMode = mode.ordinal() + 1;
        if (!Config.enableBackpackResupply && nextMode == BackpackMode.RESUPPLY.ordinal()) {
            ++nextMode;
        }
        itemstack.func_196085_b(nextMode %= BackpackMode.values().length);
    }

    @Nullable
    private static IItemHandler getInventoryHit(World world, BlockPos pos, Direction side) {
        TileEntity targeted = TileUtil.getTile((IBlockReader)world, pos);
        return TileUtil.getInventoryFromTile(targeted, side);
    }

    private boolean evaluateTileHit(ItemStack stack, PlayerEntity player, World world, BlockPos pos, Direction side) {
        IItemHandler inventory = ItemBackpack.getInventoryHit(world, pos, side);
        if (inventory != null) {
            if (inventory.getSlots() <= 0) {
                return true;
            }
            if (!world.field_72995_K) {
                ItemInventoryBackpack backpackInventory = new ItemInventoryBackpack(player, this.getBackpackSize(), stack);
                BackpackMode mode = ItemBackpack.getMode(stack);
                if (mode == BackpackMode.RECEIVE) {
                    this.receiveFromChest(backpackInventory, inventory);
                } else {
                    ItemBackpack.transferToChest(backpackInventory, inventory);
                }
            }
            return true;
        }
        return false;
    }

    private static void transferToChest(ItemInventoryBackpack backpackInventory, IItemHandler target) {
        ItemHandlerInventoryManipulator manipulator = new ItemHandlerInventoryManipulator(backpackInventory.getItemHandler());
        manipulator.transferStacks(target, StandardStackFilters.ALL);
    }

    private void receiveFromChest(ItemInventoryBackpack backpackInventory, IItemHandler target) {
        ItemHandlerInventoryManipulator manipulator = new ItemHandlerInventoryManipulator(target);
        manipulator.transferStacks(backpackInventory.getItemHandler(), this.definition.getFilter());
    }

    public int getBackpackSize() {
        return ItemBackpack.getSlotsForType(this.type);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack itemstack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemstack, world, list, flag);
        int occupied = ItemInventory.getOccupiedSlotCount(itemstack);
        BackpackMode mode = ItemBackpack.getMode(itemstack);
        String infoKey = mode.getUnlocalizedInfo();
        if (infoKey != null) {
            list.add((ITextComponent)new TranslationTextComponent(infoKey).func_240699_a_(TextFormatting.GRAY));
        }
        list.add((ITextComponent)new TranslationTextComponent("for.gui.slots", new Object[]{String.valueOf(occupied), String.valueOf(this.getBackpackSize())}).func_240699_a_(TextFormatting.GRAY));
    }

    public ITextComponent func_200295_i(ItemStack itemstack) {
        return this.definition.getName(itemstack);
    }

    @Override
    public int getColorFromItemStack(ItemStack itemstack, int j) {
        if (j == 0) {
            return this.definition.getPrimaryColour();
        }
        if (j == 1) {
            return this.definition.getSecondaryColour();
        }
        return 0xFFFFFF;
    }

    private static int getSlotsForType(EnumBackpackType type) {
        switch (type) {
            case NATURALIST: {
                return 125;
            }
            case WOVEN: {
                return 45;
            }
        }
        return 15;
    }

    public static BackpackMode getMode(ItemStack backpack) {
        Preconditions.checkArgument((boolean)(backpack.func_77973_b() instanceof ItemBackpack), (Object)"Item must be a backpack");
        int meta = backpack.func_77952_i();
        if (meta >= 3) {
            return BackpackMode.RESUPPLY;
        }
        if (meta >= 2) {
            return BackpackMode.RECEIVE;
        }
        if (meta >= 1) {
            return BackpackMode.LOCKED;
        }
        return BackpackMode.NEUTRAL;
    }

    public static EnumBackpackType getType(ItemStack backpack) {
        Preconditions.checkArgument((boolean)(backpack.func_77973_b() instanceof ItemBackpack), (Object)"Item must be a backpack");
        return ((ItemBackpack)backpack.func_77973_b()).type;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        Item newItem;
        Item oldItem = oldStack.func_77973_b();
        return oldItem != (newItem = newStack.func_77973_b()) || ItemBackpack.getMode(oldStack) != ItemBackpack.getMode(newStack);
    }

    @Override
    @Nullable
    public Container getContainer(int windowId, PlayerEntity player, ItemStack heldItem) {
        Item item = heldItem.func_77973_b();
        if (!(item instanceof ItemBackpack)) {
            return null;
        }
        ItemBackpack backpack = (ItemBackpack)item;
        switch (backpack.type) {
            case NORMAL: {
                return new ContainerBackpack(windowId, player, ContainerBackpack.Size.DEFAULT, heldItem);
            }
            case WOVEN: {
                return new ContainerBackpack(windowId, player, ContainerBackpack.Size.T2, heldItem);
            }
        }
        return null;
    }
}

