/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import forestry.api.modules.ForestryModule;
import forestry.api.storage.IBackpackInterface;
import forestry.core.IPickupHandler;
import forestry.core.IResupplyHandler;
import forestry.core.data.ForestryTags;
import forestry.modules.BlankForestryModule;
import forestry.storage.BackpackDefinition;
import forestry.storage.BackpackFilter;
import forestry.storage.BackpackInterface;
import forestry.storage.PickupHandlerStorage;
import forestry.storage.ResupplyHandler;
import forestry.storage.features.BackpackContainers;
import forestry.storage.gui.GuiBackpack;
import java.awt.Color;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;

@ForestryModule(moduleID="backpacks", containerID="forestry", name="Backpack", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.backpacks.description", lootTable="storage")
public class ModuleBackpacks
extends BlankForestryModule {
    public static final IBackpackInterface BACKPACK_INTERFACE = new BackpackInterface();
    public static final BackpackDefinition APIARIST = new BackpackDefinition(new Color(12882493), Color.WHITE, BACKPACK_INTERFACE.createNaturalistBackpackFilter("rootBees"));
    public static final BackpackDefinition LEPIDOPTERIST = new BackpackDefinition(new Color(10050353), Color.WHITE, BACKPACK_INTERFACE.createNaturalistBackpackFilter("rootButterflies"));
    public static final BackpackDefinition MINER = new BackpackDefinition(new Color(3545213), Color.WHITE, new BackpackFilter((ITag<Item>)ForestryTags.Items.MINER_ALLOW, (ITag<Item>)ForestryTags.Items.MINER_REJECT));
    public static final BackpackDefinition DIGGER = new BackpackDefinition(new Color(3554501), Color.WHITE, new BackpackFilter((ITag<Item>)ForestryTags.Items.DIGGER_ALLOW, (ITag<Item>)ForestryTags.Items.DIGGER_REJECT));
    public static final BackpackDefinition FORESTER = new BackpackDefinition(new Color(3437607), Color.WHITE, new BackpackFilter((ITag<Item>)ForestryTags.Items.FORESTER_ALLOW, (ITag<Item>)ForestryTags.Items.FORESTER_REJECT));
    public static final BackpackDefinition HUNTER = new BackpackDefinition(new Color(4268565), Color.WHITE, new BackpackFilter((ITag<Item>)ForestryTags.Items.HUNTER_ALLOW, (ITag<Item>)ForestryTags.Items.HUNTER_REJECT));
    public static final BackpackDefinition ADVENTURER = new BackpackDefinition(new Color(8370370), Color.WHITE, new BackpackFilter((ITag<Item>)ForestryTags.Items.ADVENTURER_ALLOW, (ITag<Item>)ForestryTags.Items.ADVENTURER_REJECT));
    public static final BackpackDefinition BUILDER = new BackpackDefinition(new Color(0xDD3A3A), Color.WHITE, new BackpackFilter((ITag<Item>)ForestryTags.Items.BUILDER_ALLOW, (ITag<Item>)ForestryTags.Items.BUILDER_REJECT));

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerGuiFactories() {
        ScreenManager.func_216911_a(BackpackContainers.BACKPACK.containerType(), GuiBackpack::new);
    }

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public IPickupHandler getPickupHandler() {
        return new PickupHandlerStorage();
    }

    @Override
    public IResupplyHandler getResupplyHandler() {
        return new ResupplyHandler();
    }
}

