/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting.tiles;

import forestry.api.genetics.GeneticCapabilities;
import forestry.api.genetics.IForestrySpeciesRoot;
import forestry.api.genetics.filter.IFilterData;
import forestry.api.genetics.filter.IFilterLogic;
import forestry.core.inventory.AdjacentInventoryCache;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketBufferForestry;
import forestry.core.tiles.TileForestry;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.sorting.FilterData;
import forestry.sorting.FilterLogic;
import forestry.sorting.features.SortingTiles;
import forestry.sorting.gui.ContainerGeneticFilter;
import forestry.sorting.inventory.InventoryFilter;
import forestry.sorting.inventory.ItemHandlerFilter;
import forestry.sorting.tiles.IFilterContainer;
import genetics.api.individual.IIndividual;
import genetics.api.organism.IOrganismType;
import genetics.api.root.IRootDefinition;
import genetics.utils.RootUtils;
import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileGeneticFilter
extends TileForestry
implements IStreamableGui,
IFilterContainer {
    private static final int TRANSFER_DELAY = 5;
    private final FilterLogic logic;
    private final AdjacentInventoryCache inventoryCache = new AdjacentInventoryCache(this, this.getTileCache());

    public TileGeneticFilter() {
        super(SortingTiles.GENETIC_FILTER.tileType());
        this.logic = new FilterLogic(this, (logic1, server, player) -> this.sendToPlayers(server, player));
        this.setInternalInventory(new InventoryFilter(this));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT data) {
        super.func_189515_b(data);
        data.func_218657_a("Logic", (INBT)this.logic.write(new CompoundNBT()));
        return data;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT data) {
        super.func_230337_a_(state, data);
        this.logic.read(data.func_74775_l("Logic"));
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        this.logic.writeGuiData(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readGuiData(PacketBufferForestry data) {
        this.logic.readGuiData(data);
    }

    private void sendToPlayers(ServerWorld server, PlayerEntity PlayerEntity2) {
        for (PlayerEntity player : server.func_217369_A()) {
            if (player == PlayerEntity2 || !(player.field_71070_bA instanceof ContainerGeneticFilter) || !((ContainerGeneticFilter)PlayerEntity2.field_71070_bA).hasSameTile((ContainerGeneticFilter)player.field_71070_bA)) continue;
            ((ContainerGeneticFilter)player.field_71070_bA).setGuiNeedsUpdate(true);
        }
    }

    @Override
    protected void updateServerSide() {
        if (this.updateOnInterval(5)) {
            for (Direction facing : Direction.field_199792_n) {
                ItemStack stack = this.func_70301_a(facing.func_176745_a());
                if (stack.func_190926_b()) continue;
                ItemStack transferredStack = this.transferItem(stack, facing);
                int remaining = stack.func_190916_E() - transferredStack.func_190916_E();
                if (remaining > 0) {
                    stack = stack.func_77946_l();
                    stack.func_190920_e(remaining);
                    ItemStackUtil.dropItemStackAsEntity(stack.func_77946_l(), this.field_145850_b, this.field_174879_c.func_177958_n(), (float)this.field_174879_c.func_177956_o() + 0.5f, this.field_174879_c.func_177952_p());
                }
                this.func_70299_a(facing.func_176745_a(), ItemStack.field_190927_a);
            }
        }
    }

    public boolean isConnected(Direction facing) {
        if (this.inventoryCache.getAdjacentInventory(facing) != null) {
            return true;
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
        return TileUtil.getInventoryFromTile(tileEntity, facing.func_176734_d()) != null;
    }

    private ItemStack transferItem(ItemStack itemStack, Direction facing) {
        IItemHandler itemHandler = this.inventoryCache.getAdjacentInventory(facing);
        if (itemHandler == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack transferredStack = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)itemStack.func_77946_l(), (boolean)true);
        if (transferredStack.func_190916_E() == itemStack.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        transferredStack = ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)itemStack.func_77946_l(), (boolean)false);
        if (transferredStack.func_190926_b()) {
            return itemStack;
        }
        ItemStack copy = itemStack.func_77946_l();
        copy.func_190920_e(itemStack.func_190916_E() - transferredStack.func_190916_E());
        return copy;
    }

    public Collection<Direction> getValidDirections(ItemStack itemStack, Direction from) {
        IRootDefinition definition = RootUtils.getRoot(itemStack);
        IIndividual individual = null;
        IOrganismType type = null;
        if (definition.isPresent()) {
            IForestrySpeciesRoot root = (IForestrySpeciesRoot)definition.get();
            individual = root.create(itemStack).orElse(null);
            type = root.getTypes().getType(itemStack).orElse(null);
        }
        FilterData filterData = new FilterData(definition, individual, type);
        LinkedList<Direction> validFacings = new LinkedList<Direction>();
        for (Direction facing : Direction.field_199792_n) {
            if (facing == from || !this.isValidFacing(facing, itemStack, filterData)) continue;
            validFacings.add(facing);
        }
        return validFacings;
    }

    private boolean isValidFacing(Direction facing, ItemStack itemStack, IFilterData filterData) {
        return this.inventoryCache.getAdjacentInventory(facing) != null && this.logic.isValid(facing, itemStack, filterData);
    }

    @Override
    public IFilterLogic getLogic() {
        return this.logic;
    }

    @Override
    public IInventory getBuffer() {
        return this;
    }

    @Override
    public TileGeneticFilter getTileEntity() {
        return this;
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerGeneticFilter(windowId, player.field_71071_by, this);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != null) {
            return LazyOptional.of(() -> new ItemHandlerFilter(this, facing)).cast();
        }
        if (capability == GeneticCapabilities.FILTER_LOGIC) {
            return LazyOptional.of(() -> this.logic).cast();
        }
        return super.getCapability(capability, facing);
    }
}

