/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting.blocks;

import forestry.core.blocks.BlockForestry;
import forestry.core.tiles.TileUtil;
import forestry.sorting.tiles.TileGeneticFilter;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockGeneticFilter
extends BlockForestry {
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    public static final BooleanProperty UP = BooleanProperty.func_177716_a((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.func_177716_a((String)"down");
    private static final AxisAlignedBB BOX_CENTER = new AxisAlignedBB(0.3125, 0.3125, 0.3125, 0.6875, 0.6875, 0.6875);
    private static final AxisAlignedBB BOX_DOWN = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.3125, 0.75);
    private static final AxisAlignedBB BOX_UP = new AxisAlignedBB(0.25, 0.6875, 0.25, 0.75, 1.0, 0.75);
    private static final AxisAlignedBB BOX_NORTH = new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 0.3125);
    private static final AxisAlignedBB BOX_SOUTH = new AxisAlignedBB(0.25, 0.25, 0.6875, 0.75, 0.75, 1.0);
    private static final AxisAlignedBB BOX_WEST = new AxisAlignedBB(0.0, 0.25, 0.25, 0.3125, 0.75, 0.75);
    private static final AxisAlignedBB BOX_EAST = new AxisAlignedBB(0.6875, 0.25, 0.25, 1.0, 0.75, 0.75);
    private static final AxisAlignedBB[] BOX_FACES = new AxisAlignedBB[]{BOX_DOWN, BOX_UP, BOX_NORTH, BOX_SOUTH, BOX_WEST, BOX_EAST};

    public BlockGeneticFilter() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(0.25f, 3.0f).func_208770_d().func_226896_b_(), false);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState changedState, IWorld world, BlockPos pos, BlockPos changedPos) {
        TileGeneticFilter geneticFilter = TileUtil.getTile((IBlockReader)world, pos, TileGeneticFilter.class);
        if (geneticFilter == null) {
            return this.func_176223_P();
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(geneticFilter.isConnected(Direction.NORTH)))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(geneticFilter.isConnected(Direction.EAST)))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(geneticFilter.isConnected(Direction.SOUTH)))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(geneticFilter.isConnected(Direction.WEST)))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(geneticFilter.isConnected(Direction.UP)))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(geneticFilter.isConnected(Direction.DOWN)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult rayTraceResult) {
        TileGeneticFilter tile = TileUtil.getTile((IBlockReader)worldIn, pos, TileGeneticFilter.class);
        if (tile != null && TileUtil.isUsableByPlayer(playerIn, tile)) {
            if (!worldIn.field_72995_K) {
                ServerPlayerEntity sPlayer = (ServerPlayerEntity)playerIn;
                NetworkHooks.openGui((ServerPlayerEntity)sPlayer, (INamedContainerProvider)tile, (BlockPos)pos);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileGeneticFilter();
    }
}

