/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting;

import forestry.api.core.ILocatable;
import forestry.api.genetics.alleles.AlleleManager;
import forestry.api.genetics.filter.IFilterData;
import forestry.api.genetics.filter.IFilterLogic;
import forestry.api.genetics.filter.IFilterRuleType;
import forestry.core.utils.NetworkUtil;
import forestry.sorting.AlleleFilter;
import forestry.sorting.DefaultFilterRuleType;
import forestry.sorting.FilterData;
import forestry.sorting.network.packets.PacketFilterChangeGenome;
import forestry.sorting.network.packets.PacketFilterChangeRule;
import genetics.api.GeneticsAPI;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleRegistry;
import genetics.api.alleles.IAlleleSpecies;
import genetics.api.individual.IGenome;
import genetics.api.individual.IIndividual;
import genetics.api.organism.IOrganismType;
import genetics.api.root.IRootDefinition;
import genetics.utils.AlleleUtils;
import genetics.utils.RootUtils;
import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FilterLogic
implements IFilterLogic {
    private final ILocatable locatable;
    private final IFilterLogic.INetworkHandler networkHandler;
    private IFilterRuleType[] filterRules = new IFilterRuleType[6];
    private AlleleFilter[][] genomeFilter = new AlleleFilter[6][3];

    public FilterLogic(ILocatable locatable, IFilterLogic.INetworkHandler networkHandler) {
        this.locatable = locatable;
        this.networkHandler = networkHandler;
        for (int i = 0; i < this.filterRules.length; ++i) {
            this.filterRules[i] = AlleleManager.filterRegistry.getDefaultRule();
        }
    }

    @Override
    public IFilterLogic.INetworkHandler getNetworkHandler() {
        return this.networkHandler;
    }

    @Override
    public CompoundNBT write(CompoundNBT data) {
        int i;
        for (i = 0; i < this.filterRules.length; ++i) {
            data.func_74778_a("TypeFilter" + i, this.filterRules[i].getUID());
        }
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                AlleleFilter filter = this.genomeFilter[i][j];
                if (filter == null) continue;
                if (filter.activeAllele != null) {
                    data.func_74778_a("GenomeFilterS" + i + "-" + j + "-" + 0, filter.activeAllele.getRegistryName().toString());
                }
                if (filter.inactiveAllele == null) continue;
                data.func_74778_a("GenomeFilterS" + i + "-" + j + "-" + 1, filter.inactiveAllele.getRegistryName().toString());
            }
        }
        return data;
    }

    @Override
    public void read(CompoundNBT data) {
        int i;
        for (i = 0; i < this.filterRules.length; ++i) {
            this.filterRules[i] = AlleleManager.filterRegistry.getRuleOrDefault(data.func_74779_i("TypeFilter" + i));
        }
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                AlleleFilter filter = new AlleleFilter();
                if (data.func_74764_b("GenomeFilterS" + i + "-" + j + "-" + 0)) {
                    filter.activeAllele = AlleleUtils.getAlleleOrNull(data.func_74779_i("GenomeFilterS" + i + "-" + j + "-" + 0));
                }
                if (data.func_74764_b("GenomeFilterS" + i + "-" + j + "-" + 1)) {
                    filter.inactiveAllele = AlleleUtils.getAlleleOrNull(data.func_74779_i("GenomeFilterS" + i + "-" + j + "-" + 1));
                }
                this.genomeFilter[i][j] = filter;
            }
        }
    }

    @Override
    public void writeGuiData(PacketBuffer data) {
        for (IFilterRuleType filterRule : this.filterRules) {
            data.writeShort(AlleleManager.filterRegistry.getId(filterRule));
        }
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                AlleleFilter filter = this.genomeFilter[i][j];
                if (filter == null) {
                    data.writeBoolean(false);
                    data.writeBoolean(false);
                    continue;
                }
                if (filter.activeAllele != null) {
                    data.writeBoolean(true);
                    data.func_180714_a(filter.activeAllele.getRegistryName().toString());
                } else {
                    data.writeBoolean(false);
                }
                if (filter.inactiveAllele != null) {
                    data.writeBoolean(true);
                    data.func_180714_a(filter.inactiveAllele.getRegistryName().toString());
                    continue;
                }
                data.writeBoolean(false);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readGuiData(PacketBuffer data) {
        for (int i = 0; i < this.filterRules.length; ++i) {
            this.filterRules[i] = AlleleManager.filterRegistry.getRule(data.readShort());
        }
        IAlleleRegistry alleleRegistry = GeneticsAPI.apiInstance.getAlleleRegistry();
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                AlleleFilter filter = new AlleleFilter();
                if (data.readBoolean()) {
                    filter.activeAllele = AlleleUtils.getAlleleOrNull(data.func_150789_c(1024));
                }
                if (data.readBoolean()) {
                    filter.inactiveAllele = AlleleUtils.getAlleleOrNull(data.func_150789_c(1024));
                }
                this.genomeFilter[i][j] = filter;
            }
        }
    }

    @Override
    public Collection<Direction> getValidDirections(ItemStack itemStack, Direction from) {
        IRootDefinition definition = RootUtils.getRoot(itemStack);
        IIndividual individual = null;
        IOrganismType type = null;
        if (definition.isPresent()) {
            Object root = definition.get();
            individual = root.create(itemStack).orElse(null);
            type = root.getTypes().getType(itemStack).orElse(null);
        }
        FilterData filterData = new FilterData(definition, individual, type);
        LinkedList<Direction> validFacings = new LinkedList<Direction>();
        for (Direction facing : Direction.field_199792_n) {
            if (facing == from || !this.isValid(facing, itemStack, filterData)) continue;
            validFacings.add(facing);
        }
        return validFacings;
    }

    @Override
    public boolean isValid(ItemStack itemStack, Direction facing) {
        IRootDefinition definition = RootUtils.getRoot(itemStack);
        IIndividual individual = null;
        IOrganismType type = null;
        if (definition.isPresent()) {
            Object root = definition.get();
            individual = root.create(itemStack).orElse(null);
            type = root.getTypes().getType(itemStack).orElse(null);
        }
        return this.isValid(facing, itemStack, new FilterData(definition, individual, type));
    }

    @Override
    public boolean isValid(Direction facing, ItemStack itemStack, IFilterData filterData) {
        IFilterRuleType rule = this.getRule(facing);
        if (rule == DefaultFilterRuleType.CLOSED) {
            return false;
        }
        if (rule == DefaultFilterRuleType.ITEM && !filterData.isPresent()) {
            return true;
        }
        String requiredRoot = rule.getRootUID();
        if (!(requiredRoot == null || filterData.isPresent() && filterData.getRoot().getUID().equals(requiredRoot))) {
            return false;
        }
        if (rule == DefaultFilterRuleType.ANYTHING || rule.isValid(itemStack, filterData)) {
            if (filterData.isPresent()) {
                IIndividual ind = filterData.getIndividual();
                IGenome genome = ind.getGenome();
                IAlleleSpecies active = genome.getPrimary();
                IAlleleSpecies inactive = genome.getSecondary();
                return this.isValidAllelePair(facing, active.getRegistryName().toString(), inactive.getRegistryName().toString());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isValidAllelePair(Direction orientation, String activeUID, String inactiveUID) {
        AlleleFilter[] directionFilters = this.genomeFilter[orientation.ordinal()];
        if (directionFilters == null) {
            return true;
        }
        boolean foundFilter = false;
        for (int i = 0; i < 3; ++i) {
            AlleleFilter filter = directionFilters[i];
            if (filter == null || filter.isEmpty()) continue;
            foundFilter = true;
            if (filter.isEmpty() || !filter.isValid(activeUID, inactiveUID)) continue;
            return true;
        }
        return !foundFilter;
    }

    @Override
    public IFilterRuleType getRule(Direction facing) {
        return this.filterRules[facing.ordinal()];
    }

    @Override
    public boolean setRule(Direction facing, IFilterRuleType rule) {
        if (this.filterRules[facing.ordinal()] != rule) {
            this.filterRules[facing.ordinal()] = rule;
            return true;
        }
        return false;
    }

    @Nullable
    public AlleleFilter getGenomeFilter(Direction facing, int index) {
        return this.genomeFilter[facing.ordinal()][index];
    }

    @Override
    @Nullable
    public IAllele getGenomeFilter(Direction facing, int index, boolean active) {
        AlleleFilter filter = this.getGenomeFilter(facing, index);
        if (filter == null) {
            return null;
        }
        return active ? filter.activeAllele : filter.inactiveAllele;
    }

    @Override
    public boolean setGenomeFilter(Direction facing, int index, boolean active, @Nullable IAllele allele) {
        boolean set;
        AlleleFilter filter = this.genomeFilter[facing.ordinal()][index];
        if (filter == null) {
            AlleleFilter alleleFilter = new AlleleFilter();
            this.genomeFilter[facing.ordinal()][index] = alleleFilter;
            filter = alleleFilter;
        }
        if (active) {
            set = filter.activeAllele != allele;
            filter.activeAllele = allele;
        } else {
            set = filter.inactiveAllele != allele;
            filter.inactiveAllele = allele;
        }
        return set;
    }

    @Override
    public void sendToServer(Direction facing, int index, boolean active, @Nullable IAllele allele) {
        NetworkUtil.sendToServer(new PacketFilterChangeGenome(this.locatable.getCoordinates(), facing, (short)index, active, allele));
    }

    @Override
    public void sendToServer(Direction facing, IFilterRuleType rule) {
        NetworkUtil.sendToServer(new PacketFilterChangeRule(this.locatable.getCoordinates(), facing, rule));
    }
}

