/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting;

import forestry.api.genetics.filter.IFilterData;
import genetics.api.individual.IIndividual;
import genetics.api.organism.IOrganismType;
import genetics.api.root.IIndividualRoot;
import genetics.api.root.IRootDefinition;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

public class FilterData
implements IFilterData {
    private IRootDefinition definition;
    @Nullable
    private IIndividual individual;
    @Nullable
    private IOrganismType type;

    public FilterData(IRootDefinition root, @Nullable IIndividual individual, @Nullable IOrganismType type) {
        this.definition = root;
        this.individual = individual;
        this.type = type;
    }

    @Override
    public IIndividualRoot getRoot() {
        if (!this.definition.isPresent()) {
            throw new NoSuchElementException("No root present");
        }
        return this.definition.get();
    }

    @Override
    public IRootDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public IIndividual getIndividual() {
        if (this.individual == null) {
            throw new NoSuchElementException("No individual present");
        }
        return this.individual;
    }

    @Override
    public IOrganismType getType() {
        if (this.type == null) {
            throw new NoSuchElementException("No type present");
        }
        return this.type;
    }

    @Override
    public boolean isPresent() {
        return !this.definition.isPresent() && this.individual != null && this.type != null;
    }
}

