/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules.features;

import forestry.modules.features.IModFeature;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface IEntityTypeFeature<E extends Entity>
extends IModFeature {
    @Override
    default public void create() {
        EntityType entityType = this.getEntityTypeConstructor().func_206830_a(this.getIdentifier());
        entityType.setRegistryName(new ResourceLocation(this.getModId(), this.getIdentifier()));
        this.setEntityType(entityType);
    }

    default public <R extends IForgeRegistryEntry<R>> void register(RegistryEvent.Register<R> event) {
        IForgeRegistry registry = event.getRegistry();
        Class superType = registry.getRegistrySuperType();
        if (EntityType.class.isAssignableFrom(superType) && this.hasEntityType()) {
            registry.register(this.entityType());
            GlobalEntityTypeAttributes.put(this.entityType(), (AttributeModifierMap)this.createAttributes().func_233813_a_());
        }
    }

    default public EntityType<E> entityType() {
        EntityType<E> tileType = this.getEntityType();
        if (tileType == null) {
            throw new IllegalStateException("Called feature getter method before content creation.");
        }
        return tileType;
    }

    public AttributeModifierMap.MutableAttribute createAttributes();

    public void setEntityType(EntityType<E> var1);

    public EntityType.Builder<E> getEntityTypeConstructor();

    public boolean hasEntityType();

    @Nullable
    public EntityType<E> getEntityType();
}

