/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules.features;

import forestry.core.items.definitions.DrinkProperties;
import forestry.core.render.ForestryResource;
import forestry.modules.features.FeatureFluid;
import java.awt.Color;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class FluidProperties {
    public final int density;
    public final int viscosity;
    public final int temperature;
    public final Color particleColor;
    public final int flammability;
    public final boolean flammable;
    @Nullable
    public final DrinkProperties properties;
    public final ResourceLocation[] resources = new ResourceLocation[2];
    public final Supplier<Item> bucket;

    public FluidProperties(FeatureFluid.Builder builder) {
        this.density = builder.density;
        this.viscosity = builder.viscosity;
        this.temperature = builder.temperature;
        this.particleColor = builder.particleColor;
        this.flammability = builder.flammability;
        this.flammable = builder.flammable;
        this.properties = builder.properties;
        this.resources[0] = new ForestryResource("block/liquid/" + builder.identifier + "_still");
        this.resources[1] = new ForestryResource("block/liquid/" + builder.identifier + "_flow");
        if (!this.resourceExists(this.resources[1])) {
            this.resources[1] = this.resources[0];
        }
        this.bucket = builder.bucket;
    }

    public boolean resourceExists(ResourceLocation location) {
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            return true;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft == null) {
            return false;
        }
        IResourceManager resourceManager = minecraft.func_195551_G();
        return resourceManager.func_219533_b(location);
    }
}

