/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules.features;

import forestry.api.core.IBlockSubtype;
import forestry.api.core.IFeatureSubtype;
import forestry.api.core.IItemProvider;
import forestry.core.utils.datastructures.TriFunction;
import forestry.modules.features.FeatureBlock;
import forestry.modules.features.FeatureTable;
import forestry.modules.features.IBlockFeature;
import forestry.modules.features.IFeatureRegistry;
import forestry.modules.features.IItemFeature;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;

public class FeatureBlockTable<B extends Block, R extends IBlockSubtype, C extends IBlockSubtype>
extends FeatureTable<Builder<B, R, C>, FeatureBlock<B, BlockItem>, R, C> {
    public FeatureBlockTable(Builder<B, R, C> builder) {
        super(builder);
    }

    @Override
    protected FeatureBlock<B, BlockItem> createFeature(Builder<B, R, C> builder, R rowType, C columnType) {
        return builder.registry.block(() -> (Block)builder.constructor.apply(rowType, columnType), block -> builder.itemConstructor != null ? (BlockItem)builder.itemConstructor.apply(block, rowType, columnType) : null, builder.getIdentifier((IFeatureSubtype)rowType, (IFeatureSubtype)columnType));
    }

    public Collection<B> getBlocks() {
        return this.featureByTypes.values().stream().map(IBlockFeature::block).collect(Collectors.toList());
    }

    public Collection<BlockItem> getItems() {
        return this.featureByTypes.values().stream().filter(IItemProvider::hasItem).map(IItemFeature::item).collect(Collectors.toList());
    }

    public Collection<B> getRowBlocks(R rowType) {
        return this.getRowFeatures(rowType).stream().map(IBlockFeature::block).collect(Collectors.toList());
    }

    public Collection<B> getColumnBlocks(C columnType) {
        return this.getColumnFeatures(columnType).stream().map(IBlockFeature::block).collect(Collectors.toList());
    }

    public static class Builder<B extends Block, R extends IBlockSubtype, C extends IBlockSubtype>
    extends FeatureTable.Builder<R, C, FeatureBlockTable<B, R, C>> {
        private final IFeatureRegistry registry;
        private final BiFunction<R, C, B> constructor;
        @Nullable
        private TriFunction<B, R, C, BlockItem> itemConstructor;

        public Builder(IFeatureRegistry registry, BiFunction<R, C, B> constructor) {
            super(registry);
            this.registry = registry;
            this.constructor = constructor;
        }

        public Builder<B, R, C> itemWithType(TriFunction<B, R, C, BlockItem> itemConstructor) {
            this.itemConstructor = itemConstructor;
            return this;
        }

        public Builder<B, R, C> item(Function<B, BlockItem> itemConstructor) {
            this.itemConstructor = (block, rowType, columnType) -> (BlockItem)itemConstructor.apply(block);
            return this;
        }

        @Override
        public FeatureBlockTable<B, R, C> create() {
            return new FeatureBlockTable(this);
        }
    }
}

